#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>

#define TEXT_ALIGNMENT_LEFT    0
#define TEXT_ALIGNMENT_CENTER  1
#define TEXT_ALIGNMENT_RIGHT   2

//Text Font
#define TEXT_FONT_A            0
#define TEXT_FONT_B            1
#define TEXT_FONT_C            2

#define TEXT_SIZE_0WIDTH       0
#define TEXT_SIZE_1WIDTH       16
#define TEXT_SIZE_2WIDTH       32
#define TEXT_SIZE_3WIDTH       48
#define TEXT_SIZE_4WIDTH       64
#define TEXT_SIZE_5WIDTH       80
#define TEXT_SIZE_6WIDTH       96
#define TEXT_SIZE_7WIDTH       112

#define TEXT_SIZE_0HEIGHT      0
#define TEXT_SIZE_1HEIGHT      1
#define TEXT_SIZE_2HEIGHT      2
#define TEXT_SIZE_3HEIGHT      3
#define TEXT_SIZE_4HEIGHT      4
#define TEXT_SIZE_5HEIGHT      5
#define TEXT_SIZE_6HEIGHT      6
#define TEXT_SIZE_7HEIGHT      7

#define	TEXT_NORMAL_MODE            0
#define	TEXT_FONT_EMPHASIZED        2
#define	TEXT_FONT_UNDERLINE_MODE    4
#define	TEXT_FONT_REVERSE           8
#define	TEXT_FONT_DH_MODE           16
#define	TEXT_FONT_DW_MODE           32
#define	TEXT_FONT_DW_DH_MODE        48

/* Bar Code Type */
#define BARCODE_UPC_A      65
#define BARCODE_UPC_E	   66
#define BARCODE_EAN13      67
#define BARCODE_JAN13	   67
#define BARCODE_EAN8	   68
#define BARCODE_JAN8       68
#define BARCODE_CODE39     69
#define BARCODE_ITF        70
#define BARCODE_CODABAR    71
#define BARCODE_CODE93     72
#define BARCODE_CODE128    73

#define SYMBOL_STANDARD_PDF417		101
#define SYMBOL_TRUNCATED_PDF417		102
#define	SYMBOL_QRCODE1				103
#define	SYMBOL_QRCODE2				104
//PDF417 Code error correction level
#define PDF417_ERROR_CORRECTION_LEVEL_0  48
#define PDF417_ERROR_CORRECTION_LEVEL_1  49
#define PDF417_ERROR_CORRECTION_LEVEL_2  50
#define PDF417_ERROR_CORRECTION_LEVEL_3  51
#define PDF417_ERROR_CORRECTION_LEVEL_4  52
#define PDF417_ERROR_CORRECTION_LEVEL_5  53
#define PDF417_ERROR_CORRECTION_LEVEL_6  54
#define PDF417_ERROR_CORRECTION_LEVEL_7  55
#define PDF417_ERROR_CORRECTION_LEVEL_8  56

#define BARCODE_HRI_FONT_A  0
#define BARCODE_HRI_FONT_B  1

#define BARCODE_HRI_NONE   0
#define BARCODE_HRI_ABOVE  1
#define BARCODE_HRI_BELOW  2
#define BARCODE_HRI_BOTH   3

//Symbol model
#define SYMBOL_MODEL_1  49
#define SYMBOL_MODEL_2  50
//Symbol error correction level
#define SYMBOL_ERROR_CORRECTION_LEVEL_L  48
#define SYMBOL_ERROR_CORRECTION_LEVEL_M  49
#define SYMBOL_ERROR_CORRECTION_LEVEL_Q  50
#define SYMBOL_ERROR_CORRECTION_LEVEL_H  51
//Print Image Scale Mode
#define PRINT_IMAGE_NORMAL				0
#define PRINT_IMAGE_DOUBLE_WIDTH		1
#define PRINT_IMAGE_DOUBLE_HEIGHT		2
#define PRINT_IMAGE_QUADRUPLE			3

//Character Code Table

#define CHARACTERSET_DEFAULT           0
#define CHARACTERSET_USA               437
#define CHARACTERSET_MULTILINGUAL      850
#define CHARACTERSET_PORTUGUESE        860
#define CHARACTERSET_CANADIAN_FRENCH   863
#define CHARACTERSET_NORDIC            865
#define CHARACTERSET_WPC1252           1252
#define CHARACTERSET_CYRILLIC2         866
#define	CHARACTERSET_LATIN2            852
#define	CHARACTERSET_EURO              858


typedef int(*FormatError)(int error_no, int langid, char* buf, int pos, int buf_size);
typedef int(*PrinterCreator)(void** phandle, unsigned char* model);
typedef void(*PrinterCreatorS)(char* model);
typedef int(*PortOpen)(void* handle, unsigned char*  io_settings);
typedef int(*PortClose)(void* handle);
typedef int(*PrinterDestroy)(void* handle);
typedef	int(*DirectIO)(void* handle, unsigned char writedata[], unsigned int writenum, unsigned char readdata[], unsigned int readnum, unsigned int* preadednum);
typedef	int(*ReadData)(void* handle, unsigned char* readData, unsigned int readNum, unsigned int* preadedNum);

typedef	int(*WriteData)(void* handle, unsigned char* writeData, unsigned int writeNum);
typedef int(*PrinterInitialize)(void* handle);
typedef int(*FeedLine)(void* handle, int lines);
typedef int(*SetAlign)(void* handle, int align);
typedef int(*PrintText)(void* handle, unsigned char* data, int alignment, int attribute, int textsize);
typedef int(*PrintTextS)(void* handle, unsigned char* data);
typedef int(*PrintBarCode)(void* handle, int bctype, unsigned char* data, int width, int height, int alignment, int HRI_position);
typedef int(*PrintSymbol)(void* handle, int type, unsigned char* data, int err_level, int width, int height, int alignment);
typedef int(*CutPaper)(void* handle, int cut_mode, int distance);
typedef int(*OpenCashDrawer)(void* handle, int pin_mode, int on_time, int off_time);
typedef int(*SelectStandardMode)(void* handle);
typedef int(*SetTextLineSpace)(void* handle, int linespace);
typedef int(*SetTextBold)(void* handle, int bold);
typedef int(*SetTextFont)(void* handle, int font);
typedef	int(*SelectPageMode)(void* handle);
typedef	int(*SetPrintAreaInPageMode)(void* handle, int horizontal, int vertical, int width, int height);
typedef	int(*CancelPrintDataInPageMode)(void* handle);
typedef	int(*SelectPrintDirectionInPageMode)(void* handle, int direction);
typedef	int(*SetAbsolutePrintPosition)(void* handle, int position);
typedef	int(*SetAbsoluteVerticalPrintPositionInPageMode)(void* handle, int position);
typedef	int(*PrintAndReturnStandardMode)(void* handle);
typedef int(*PositionNextLabel)(void* handle);
typedef	int(*PrintDataInPageMode)(void* handle);
typedef	int(*GetPrinterState)(void* handle, unsigned int* printer_state);
typedef int(*SetHorizontalAndVerticalMotionUnits)(void* handle, int  Horizontal, int Vertical);
typedef int(*SetCodePage)(void* handle, int codepage, int type);
typedef int(*SetBuzzer)(void* handle, int enable);
typedef	int(*SetInternationalCharacter)(void* handle, int characterset);
typedef	int(*SetPrintSpeed)(void* handle, int speed);
typedef int(*DefineNVImageCompatible)(void* handle, unsigned char** imagepath_list, int imageqty);
typedef int(*PrintNVImageCompatible)(void* handle, int imgno, int scalemode);
typedef int(*DefineDownloadedImageCompatible)(void* handle, unsigned char* imagepath);
typedef int(*PrintDownloadedImageCompatible)(void* handle, int scalemode);
typedef int(*PrintImage)(void* handle, unsigned char* filename, int scalemode);
typedef int(*PrintBitMapData)(void* handle, int scalemode, int width, int height,unsigned char* filename);
typedef int(*DefineNVImage)(void* handle, unsigned char* imagepath, unsigned char kc1, unsigned char kc2);
typedef int(*PrintNVImage)(void* handle, unsigned char kc1, unsigned char kc2);
typedef int(*DefineBufferedImage)(void* handle, unsigned char* imagepath);
typedef int(*PrintBufferedImage)(void* handle);
typedef int(*DeleteAllNVImages)(void* handle);
typedef	int(*GetFirmwareVersion)(void* handle, int* version, int version_len);
typedef	int(*GetCashDrawerState)(void* handle, int* drawerState);
typedef	int(*ClearBuffer)(void* handle);
typedef	int(*PrintTwoQRCode)(void* handle, unsigned char* data1, int width1, int hAlign1, int vAlign1, unsigned char* data2, int width2, int hAlign2, int vAlign2);
typedef	int(*DrawRectangle)(void* handle, int xStart, int yStart, int xArea, int yArea, int lineWidth);
typedef	int(*FirmwareUpgrade)(void* handle, unsigned char* cFileName, const char* model, const char* ioSettings);

typedef	int(*GetPaperFeedLinesNumber)(void* handle, unsigned int* number);
typedef	int(*GetHeadEnergizingStrokesNumber)(void* handle, unsigned int* number);
typedef	int(*ClearPrinterMileage)(void* handle,int clearType);
typedef	int(*GetAutocutterOperationsNumber)(void* handle, unsigned int* number);
typedef	int(*GetPrinterOperationPeriod)(void* handle, unsigned int* period);

typedef	int(*GetOverTemperatureErrorReportNumber)(void* handle, unsigned int* number);
typedef	int(*GetPrinterPointsNumber)(void* handle, unsigned int* number);
typedef	int(*GetCutterErrorNumber)(void* handle, unsigned int* number);
typedef	int(*GetPowerOnOpenCoverNumber)(void* handle, unsigned int* number);
typedef	int(*GetHalfCutNumber)(void* handle, unsigned int* number);
typedef	int(*GetTotalCutNumber)(void* handle, unsigned int* number);
typedef	int(*ClearPrinterMileage2)(void* handle);

typedef int(*GetPrinterSN)(void* handle, char* sn, int* snLenth);
typedef	int(*GetCustomPrinterState)(void* handle, unsigned int* printer_state);
typedef	int(*PrintDataMatrixCode)(void* handle, int rotation, int barcodeSize, const char* data, int dataSize);

typedef	int(*GetPrinterHeatingMileage)(void* handle, unsigned int* number);
typedef	int(*GetPrinterFeedMileage)(void* handle, unsigned int* number);
typedef	int(*GetPrinterCutterMileage)(void* handle, unsigned int* number);
typedef	int(*ClearTP80LPrinterMileage)(void* handle, int clearType);
typedef	int(*SetResetPrinter)(void* handle);
typedef	int(*SetLog)(void* handle,const char* path);

typedef	int(*FirmwareOtaUpgrade)(void* handle, const char* cFileName, const char* model, const char* ioSettings);
typedef	int(*CustomSetDensity)(void* handle, int density);
typedef	int(*CustomGetDensity)(void* handle, int *density);
typedef	int(*GetTaskFinishStatus)(void* handle, unsigned int *status);

typedef int(*RetrievePreviousPageSpeed)(void* handle, int* speed);

FormatError				DemFormatError;
PrinterCreator			DemPrinterCreator;
PrinterCreatorS			DemPrinterCreatorS;
PortOpen				DemPortOpen;
PortClose				DemPortClose;
PrinterDestroy			DemPrinterDestroy;
DirectIO				DemDirectIO;

PrinterInitialize		DemPrinterInitialize;
FeedLine				DemFeedLine;
SetAlign                DemSetAlign;
PrintText				DemPrintText;
PrintTextS				DemPrintTextS;
PrintBarCode			DemPrintBarCode;
PrintSymbol				DemPrintSymbol;
CutPaper				DemCutPaper;
OpenCashDrawer                      DemOpenCashDrawer;
SelectStandardMode					DemSelectStandardMode;
SetTextLineSpace					DemSetTextLineSpace;
SetTextBold                         DemSetTextBold;
SetTextFont                         DemSetTextFont;
SelectPageMode						DemSelectPageMode;
SetPrintAreaInPageMode				DemSetPrintAreaInPageMode;
CancelPrintDataInPageMode               DemCancelPrintDataInPageMode;
SelectPrintDirectionInPageMode			DemSelectPrintDirectionInPageMode;
SetAbsolutePrintPosition				DemSetAbsolutePrintPosition;
SetAbsoluteVerticalPrintPositionInPageMode	DemSetAbsoluteVerticalPrintPositionInPageMode;
PrintAndReturnStandardMode				DemPrintAndReturnStandardMode;
PositionNextLabel						DemPositionNextLabel;
PrintDataInPageMode						DemPrintDataInPageMode;
GetPrinterState                         DemGetPrinterState;
SetHorizontalAndVerticalMotionUnits     DemSetHorizontalAndVerticalMotionUnits;
SetCodePage                             DemSetCodePage;
SetBuzzer                               DemSetBuzzer;
SetInternationalCharacter               DemSetInternationalCharacter;
SetPrintSpeed                           DemSetPrintSpeed;
DefineNVImageCompatible					DemDefineNVImageCompatible;
PrintNVImageCompatible					DemPrintNVImageCompatible;
DefineDownloadedImageCompatible			DemDefineDownloadedImageCompatible;
PrintDownloadedImageCompatible			DemPrintDownloadedImageCompatible;
PrintImage								DemPrintImage;
DefineNVImage							DemDefineNVImage;
PrintNVImage							DemPrintNVImage;
DefineBufferedImage						DemDefineBufferedImage;
PrintBufferedImage						DemPrintBufferedImage;
DeleteAllNVImages                       DemDeleteAllNVImages;
GetFirmwareVersion                      DemGetFirmwareVersion;
GetCashDrawerState                      DemGetCashDrawerState;
ClearBuffer                             DemClearBuffer;
PrintTwoQRCode                          DemPrintTwoQRCode;
WriteData                               DemWriteData;
ReadData                                DemReadData;

GetPaperFeedLinesNumber                 DemGetPaperFeedLinesNumber;
GetHeadEnergizingStrokesNumber          DemGetHeadEnergizingStrokesNumber;
ClearPrinterMileage						DemClearPrinterMileage;
GetAutocutterOperationsNumber           DemGetAutocutterOperationsNumber;
GetPrinterOperationPeriod               DemGetPrinterOperationPeriod;

GetOverTemperatureErrorReportNumber     DemGetOverTemperatureErrorReportNumber;
GetPrinterPointsNumber					DemGetPrinterPointsNumber;
GetCutterErrorNumber					DemGetCutterErrorNumber;
GetPowerOnOpenCoverNumber               DemGetPowerOnOpenCoverNumber;
GetHalfCutNumber						DemGetHalfCutNumber;
GetTotalCutNumber						DemGetTotalCutNumber;
ClearPrinterMileage2                    DemClearPrinterMileage2;
GetPrinterSN							DemGetPrinterSN;
GetCustomPrinterState                   DemGetCustomPrinterState;
PrintDataMatrixCode						DemPrintDataMatrixCode;

GetPrinterHeatingMileage					DemGetPrinterHeatingMileage;
GetPrinterFeedMileage						DemGetPrinterFeedMileage;
GetPrinterCutterMileage						DemGetPrinterCutterMileage;
ClearTP80LPrinterMileage					DemClearTP80LPrinterMileage;
SetResetPrinter								DemSetResetPrinter;
SetLog									DemSetLog;
FirmwareUpgrade		DemFirmwareUpgrade;
FirmwareOtaUpgrade                           DemFirmwareOtaUpgrade;

CustomSetDensity									DemCustomSetDensity;
CustomGetDensity									DemCustomGetDensity;
GetTaskFinishStatus             DemGetTaskFinishStatus;
RetrievePreviousPageSpeed						DemRetrievePreviousPageSpeed;

void PrintReceipt(void* hprinter);
void PrintLabel(void* hprinter);
void PrintGetOtherNumber(void* hprinter);
void PrinterState(void* hprinter);

void DemoGetVersionSN(void* hprinter);
void DemoGetCustomPrinterState(void* hprinter);
void DemoCodePageText(void* hprinter);
void DemPrintDataMatrixCodeTest(void* hprinter);
void upgradeTest(void* hprinter);
void densityTest(void* hprinter);
void DirectIOTest(void* hprinter);
void PageSpeedTest(void* hprinter);


void Test_esc()
{	

    void *phandle = NULL;
    int status = 0;
    int result = 0;
    char error_msg[1024] = {0};
    void* m_hDll = dlopen("./libesc_sdk.so",RTLD_LAZY);
    if(!m_hDll)
    {
        printf("Failed to load shared library.\r\n");
        return;
    }
    else
    {
        printf("Load successed.\r\n");
    }

     DemFormatError = (FormatError)dlsym(m_hDll, "FormatError");
     DemPrinterCreator = (PrinterCreator)dlsym(m_hDll, "PrinterCreator");
     DemPrinterCreatorS = (PrinterCreatorS)dlsym(m_hDll, "PrinterCreatorS");
     DemPortOpen = (PortOpen)dlsym(m_hDll, "PortOpen");
     DemPortClose = (PortClose)dlsym(m_hDll, "PortClose");
     DemPrinterDestroy = (PrinterDestroy)dlsym(m_hDll, "PrinterDestroy");
     DemDirectIO = (DirectIO)dlsym(m_hDll, "DirectIO");

     DemPrinterInitialize = (PrinterInitialize)dlsym(m_hDll, "PrinterInitialize");
     DemFeedLine = (FeedLine)dlsym(m_hDll, "FeedLine");
     DemSetAlign = (SetAlign)dlsym(m_hDll, "SetAlign");
     DemPrintText = (PrintText)dlsym(m_hDll, "PrintText");
     DemPrintTextS = (PrintTextS)dlsym(m_hDll, "PrintTextS");

     DemPrintBarCode = (PrintBarCode)dlsym(m_hDll, "PrintBarCode");
     DemPrintSymbol = (PrintSymbol)dlsym(m_hDll, "PrintSymbol");
     DemCutPaper = (CutPaper)dlsym(m_hDll, "CutPaper");
     DemOpenCashDrawer = (OpenCashDrawer)dlsym(m_hDll, "OpenCashDrawer");
     DemSelectStandardMode = (SelectStandardMode)dlsym(m_hDll, "SelectStandardMode");
     DemSetTextLineSpace = (SetTextLineSpace)dlsym(m_hDll, "SetTextLineSpace");
     DemSetTextBold = (SetTextBold)dlsym(m_hDll, "SetTextBold");
     DemSetTextFont = (SetTextFont)dlsym(m_hDll, "SetTextFont");
     DemSelectPageMode = (SelectPageMode)dlsym(m_hDll, "SelectPageMode");
     DemSetPrintAreaInPageMode = (SetPrintAreaInPageMode)dlsym(m_hDll, "SetPrintAreaInPageMode");
     DemCancelPrintDataInPageMode = (CancelPrintDataInPageMode)dlsym(m_hDll, "CancelPrintDataInPageMode");
     DemSelectPrintDirectionInPageMode = (SelectPrintDirectionInPageMode)dlsym(m_hDll, "SelectPrintDirectionInPageMode");
     DemSetAbsolutePrintPosition = (SetAbsolutePrintPosition)dlsym(m_hDll, "SetAbsolutePrintPosition");
     DemSetAbsoluteVerticalPrintPositionInPageMode = (SetAbsoluteVerticalPrintPositionInPageMode)dlsym(m_hDll, "SetAbsoluteVerticalPrintPositionInPageMode");

     DemPrintAndReturnStandardMode = (PrintAndReturnStandardMode)dlsym(m_hDll, "PrintAndReturnStandardMode");
     DemPositionNextLabel = (PositionNextLabel)dlsym(m_hDll, "PositionNextLabel");
     DemPrintDataInPageMode = (PrintDataInPageMode)dlsym(m_hDll, "PrintDataInPageMode");
     DemGetPrinterState = (GetPrinterState)dlsym(m_hDll, "GetPrinterState");
     DemSetHorizontalAndVerticalMotionUnits = (SetHorizontalAndVerticalMotionUnits)dlsym(m_hDll, "SetHorizontalAndVerticalMotionUnits");
     DemSetCodePage = (SetCodePage)dlsym(m_hDll, "SetCodePage");
     DemSetBuzzer = (SetBuzzer)dlsym(m_hDll, "SetBuzzer");
     DemSetInternationalCharacter = (SetInternationalCharacter)dlsym(m_hDll, "SetInternationalCharacter");
     DemSetPrintSpeed = (SetPrintSpeed)dlsym(m_hDll, "SetPrintSpeed");

     DemDefineNVImageCompatible = (DefineNVImageCompatible)dlsym(m_hDll, "DefineNVImageCompatible");
     DemPrintNVImageCompatible = (PrintNVImageCompatible)dlsym(m_hDll, "PrintNVImageCompatible");
     DemDefineDownloadedImageCompatible = (DefineDownloadedImageCompatible)dlsym(m_hDll, "DefineDownloadedImageCompatible");
     DemPrintDownloadedImageCompatible = (PrintDownloadedImageCompatible)dlsym(m_hDll, "PrintDownloadedImageCompatible");
     DemPrintImage = (PrintImage)dlsym(m_hDll, "PrintImage");
     DemDefineNVImage = (DefineNVImage)dlsym(m_hDll, "DefineNVImage");
     DemPrintNVImage = (PrintNVImage)dlsym(m_hDll, "PrintNVImage");
     DemDefineBufferedImage = (DefineBufferedImage)dlsym(m_hDll, "DefineBufferedImage");
     DemPrintBufferedImage = (PrintBufferedImage)dlsym(m_hDll, "PrintBufferedImage");
     DemDeleteAllNVImages = (DeleteAllNVImages)dlsym(m_hDll, "DeleteAllNVImages");
     DemGetFirmwareVersion = (GetFirmwareVersion)dlsym(m_hDll, "GetFirmwareVersion");
     DemGetCashDrawerState = (GetCashDrawerState)dlsym(m_hDll, "GetCashDrawerState");
     DemClearBuffer = (ClearBuffer)dlsym(m_hDll, "ClearBuffer");
     DemPrintTwoQRCode = (PrintTwoQRCode)dlsym(m_hDll, "PrintTwoQRCode");
     DemWriteData = (WriteData)dlsym(m_hDll,"WriteData");
     DemReadData = (ReadData)dlsym(m_hDll,"ReadData");

     DemGetPaperFeedLinesNumber = (GetPaperFeedLinesNumber)dlsym(m_hDll, "GetPaperFeedLinesNumber");
     DemGetHeadEnergizingStrokesNumber = (GetHeadEnergizingStrokesNumber)dlsym(m_hDll, "GetHeadEnergizingStrokesNumber");
     DemClearPrinterMileage = (ClearPrinterMileage)dlsym(m_hDll, "ClearPrinterMileage");
     DemGetAutocutterOperationsNumber = (GetAutocutterOperationsNumber)dlsym(m_hDll, "GetAutocutterOperationsNumber");
     DemGetPrinterOperationPeriod = (GetPrinterOperationPeriod)dlsym(m_hDll, "GetPrinterOperationPeriod");

     DemGetOverTemperatureErrorReportNumber = (GetOverTemperatureErrorReportNumber)dlsym(m_hDll, "GetOverTemperatureErrorReportNumber");
     DemGetPrinterPointsNumber = (GetPrinterPointsNumber)dlsym(m_hDll, "GetPrinterPointsNumber");
     DemGetCutterErrorNumber = (GetCutterErrorNumber)dlsym(m_hDll, "GetCutterErrorNumber");
     DemGetPowerOnOpenCoverNumber = (GetPowerOnOpenCoverNumber)dlsym(m_hDll, "GetPowerOnOpenCoverNumber");
     DemGetHalfCutNumber = (GetHalfCutNumber)dlsym(m_hDll, "GetHalfCutNumber");
     DemGetTotalCutNumber = (GetTotalCutNumber)dlsym(m_hDll, "GetTotalCutNumber");
     DemClearPrinterMileage2 = (ClearPrinterMileage2)dlsym(m_hDll, "ClearPrinterMileage2");
	 
	 DemGetPrinterSN = (GetPrinterSN)dlsym(m_hDll, "GetPrinterSN");
	 DemGetCustomPrinterState = (GetCustomPrinterState)dlsym(m_hDll, "GetCustomPrinterState");
	 DemPrintDataMatrixCode = (PrintDataMatrixCode)dlsym(m_hDll, "PrintDataMatrixCode");

	
	DemGetPrinterHeatingMileage = (GetPrinterHeatingMileage)dlsym(m_hDll, "GetPrinterHeatingMileage");
	DemGetPrinterFeedMileage = (GetPrinterFeedMileage)dlsym(m_hDll, "GetPrinterFeedMileage");
	DemGetPrinterCutterMileage = (GetPrinterCutterMileage)dlsym(m_hDll, "GetPrinterCutterMileage");
	DemClearTP80LPrinterMileage = (ClearTP80LPrinterMileage)dlsym(m_hDll, "ClearTP80LPrinterMileage");
	DemSetResetPrinter = (SetResetPrinter)dlsym(m_hDll, "SetResetPrinter");
	DemSetLog = (SetLog)dlsym(m_hDll, "SetLog");
    	DemFirmwareUpgrade = (FirmwareUpgrade)dlsym(m_hDll, "FirmwareUpgrade");
	
	DemFirmwareOtaUpgrade = (FirmwareOtaUpgrade)dlsym(m_hDll, "FirmwareOtaUpgrade");
	DemCustomSetDensity = (CustomSetDensity)dlsym(m_hDll, "CustomSetDensity");
	DemCustomGetDensity = (CustomGetDensity)dlsym(m_hDll, "CustomGetDensity");
	DemGetTaskFinishStatus = (GetTaskFinishStatus)dlsym(m_hDll, "GetTaskFinishStatus");

	DemRetrievePreviousPageSpeed = (RetrievePreviousPageSpeed)dlsym(m_hDll, "RetrievePreviousPageSpeed");

    result = DemPrinterCreator(&phandle, "TP806");
    //result = DemPrinterCreator(&phandle, "N43BT");
    if (0 != result)
    {
        DemFormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
        printf("Creation fail:%s\n", error_msg);
        return;
    }
    else
    {
        printf("Creation successed\r\n");
    }

    //result = DemPortOpen(phandle, "USB,iT4S,vid=0x2AAF,pid=0x6004");//tp80k  
    //result = DemPortOpen(phandle, "USB,iT4S,vid=0x20d1,pid=0x7008");//tp80k

    result = DemPortOpen(phandle, "USB,iT4S,vid=0x2aaf,pid=0x6015");
    //result = PortOpen(phandle, "COM,ttyUSB0,BAUDRATE=115200");

    if (0 != result)
    {
       	DemFormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
        printf("Open fail:%s\n", error_msg);
        return;
    }
    else // demo start
    {
        int result = -10;
        printf("Open successed\r\n");

	PrinterState(phandle);
	DemoGetVersionSN(phandle);
        PrintReceipt(phandle);
       	PrintLabel(phandle);
	//result = DemPrintImage(phandle,"/usr/local/11.jpg",0);
	//printf("PrintImage result = %d\r\n",result);	
		
	//DemoCodePageText(phandle);
	//DemoGetCustomPrinterState(phandle);
	//DemPrintDataMatrixCodeTest(phandle);
	TaskStatus(phandle);
	//upgradeTest(phandle);
	//densityTest(phandle);
	//DirectIOTest(phandle);
	//DemGetPrinterMileage(phandle);
	//DemSetResetPrinter(phandle);

	DemPortClose(phandle);
    }
	DemPrinterDestroy(phandle);

    //printf("PortOpen result= %d\r\n",result);

    if (0 != result)
    {
            DemFormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
            printf("%s\n", error_msg);
    }
    else
    {

    }
    if(!result)
    {
        printf("ESCTest success ");
    }
    else
    {
        printf("ESCTest fail %d",result);
        DemFormatError(result, 0, (unsigned char*)error_msg, 0, sizeof(error_msg));
        printf("%s\n", error_msg);
    }
	
}

void DemPrintDataMatrixCodeTest(void* hprinter)
{
	DemPrinterInitialize(hprinter);
	char arr1[] = { 0x44,0x61,0x74,0x61,0x4D,0x61,0x74,0x72,0x69,0x78,0x3F,
			0x20,0x41,0x6C,0x73,0x6F,0x20,0x6B,0x6E,0x6F,0x77,0x6E,0x20,0x61,
			0x73,0x20,0x44,0x61,0x74,0x61,0x63,0x6F,0x64,0x65,0x2C,0x20,0x69,
			0x74,0x20,0x69,0x73,0x20,0x61,0x20,0x68,0x69,0x67,0x68,0x2D,0x64,
			0x65,0x6E,0x73,0x69,0x74,0x79,0x20,0x6D,0x61,0x74,0x72,0x69,0x78,
			0x20,0x62,0x61,0x73,0x65,0x64,0x20,0x74,0x77,0x6F,0x2D,0x64,0x69,
			0x6D,0x65,0x6E,0x73,0x69,0x6F,0x6E,0x61,0x6C,0x20,0x62,0x61,0x72,
			0x63,0x6F,0x64,0x65,0x20,0x69,0x6E,0x76,0x65,0x6E,0x74,0x65,0x64,
			0x20,0x62,0x79,0x20,0x49,0x6E,0x74,0x65,0x72,0x6E,0x61,0x74,0x69,
			0x6F,0x6E,0x61,0x6C,0x20,0x44,0x61,0x74,0x61,0x20,0x4D,0x61,0x74,
			0x72,0x69,0x78,0x20,0x28,0x49,0x44,0x20,0x4D,0x61,0x74,0x72,0x69,
			0x78,0x29,0x20,0x69,0x6E,0x20,0x31,0x39,0x38,0x39,0x2E,0x20,0x54,
			0x68,0x69,0x73,0x20,0x62,0x61,0x72,0x63,0x6F,0x64,0x65,0x20,0x74,
			0x65,0x63,0x68,0x6E,0x6F,0x6C,0x6F,0x67,0x79,0x20,0x68,0x61,0x73,
			0x20,0x62,0x65,0x65,0x6E,0x20,0x77,0x69,0x64,0x65,0x6C,0x79,0x20,
			0x75,0x73,0x65,0x64,0x20,0x69,0x6E,0x20,0x6D,0x75,0x6C,0x74,0x69,
			0x70,0x6C,0x65,0x20,0x66,0x69,0x65,0x6C,0x64,0x73,0x20,0x64,0x75,
			0x65,0x20,0x74,0x6F,0x20,0x69,0x74,0x73,0x20,0x75,0x6E,0x69,0x71,0x75,0x65,0x20,0x61,0x64,0x76,0x61,0x6E,0x74,0x61,0x67,0x65,0x73,0x2E,0x0a};

	int ret = DemPrintDataMatrixCode(hprinter, 0, 4, arr1, sizeof(arr1));
	if(ret == 0)
		printf("DemPrintDataMatrixCode test success\r\n");
	else
		printf("DemPrintDataMatrixCode test fail\r\n");
}

void PrintReceipt(void* hprinter)
{
    DemPrinterInitialize(hprinter);
    DemPrintText(hprinter,"\n", TEXT_ALIGNMENT_CENTER, TEXT_NORMAL_MODE, TEXT_SIZE_1WIDTH | TEXT_SIZE_1HEIGHT);
    //PrintNVImageCompatible(hprinter, 1, 3);
	DemPrintText(hprinter, ("Font A\n"), TEXT_ALIGNMENT_CENTER, 0, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
	DemPrintText(hprinter, ("Font A\n"), TEXT_ALIGNMENT_CENTER, 0, TEXT_SIZE_1WIDTH | TEXT_SIZE_1HEIGHT);
	DemPrintText(hprinter, ("Font A\n"), TEXT_ALIGNMENT_CENTER, 0, TEXT_SIZE_2WIDTH | TEXT_SIZE_2HEIGHT);
	DemPrintText(hprinter, ("*******************************\n"), TEXT_ALIGNMENT_CENTER, 0, TEXT_SIZE_2WIDTH | TEXT_SIZE_2HEIGHT);
	DemPrintText(hprinter, ("Font B\n"), TEXT_ALIGNMENT_CENTER, 1, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
	DemPrintText(hprinter, ("Font B\n"), TEXT_ALIGNMENT_CENTER, 1, TEXT_SIZE_1WIDTH | TEXT_SIZE_1HEIGHT);
	DemPrintText(hprinter, ("Font B\n"), TEXT_ALIGNMENT_CENTER, 1, TEXT_SIZE_2WIDTH | TEXT_SIZE_2HEIGHT);
	
    DemPrintText(hprinter,"WELCOME\n", TEXT_ALIGNMENT_CENTER, TEXT_NORMAL_MODE, TEXT_SIZE_1WIDTH | TEXT_SIZE_1HEIGHT);
    DemPrintText(hprinter,"Receipt:270500027                Cashier:01012\n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"----------------------------------------------\n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"  Commodity Code         Price        Quantity\n", TEXT_ALIGNMENT_LEFT, TEXT_FONT_EMPHASIZED | TEXT_FONT_UNDERLINE_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"01.9940228004700          3.98           1.181\n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"   banana                       subtotal:4.70 \n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"02.996100800220           6.00           0.376\n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"   noodle                       subtotal:2.20 \n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"03.6921644701204          3.50           1    \n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"   fruit juice                  subtotal:3.50 \n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"04.9940316000602          5.16           0.116\n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"   flour                        subtotal:0.60 \n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"----------------------------------------------\n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"Total:                  RMB             11.00 \n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"Payment:                RMB            101.00 \n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"Change:                 RMB             90.00 \n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"Sold Quantity:                           4    \n", TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"  13th,Sep,2014   16:50:19\n", TEXT_ALIGNMENT_CENTER, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"Thank you for patronizing\n", TEXT_ALIGNMENT_CENTER, TEXT_FONT_UNDERLINE_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
    DemPrintText(hprinter,"Wal-Mart\n", TEXT_ALIGNMENT_CENTER, TEXT_FONT_REVERSE, TEXT_SIZE_1WIDTH | TEXT_SIZE_0HEIGHT);
    DemPositionNextLabel(hprinter);
    DemCutPaper(hprinter,0,3);

}

void TaskStatus(void* hprinter)
{
	PrintReceipt(hprinter);
	PrintReceipt(hprinter);
	int status = 0;
	int ret = DemGetTaskFinishStatus(hprinter,&status);
	printf("DemGetTaskFinishStatus ret = %d,status=%d\r\n",ret,status);
	PageSpeedTest(hprinter);
}

void PrintLabel(void* hprinter)
{
    double vMotion = 0.0625, hMotion = 0.125;    // distance per dot
    int pageWidth = 72, pageHeight = 500;        // mm
    int width_dots = (int)(pageWidth / hMotion);
    int height_dots = (int)(pageHeight / vMotion);

    DemPrinterInitialize(hprinter);
    DemSelectPageMode(hprinter);

    DemSetPrintAreaInPageMode(hprinter, 0, 0, width_dots, height_dots);
    DemSelectPrintDirectionInPageMode(hprinter, 0);

    //// print Barcode: Code128
    DemSetAbsolutePrintPosition(hprinter, 20);
    DemSetAbsoluteVerticalPrintPositionInPageMode(hprinter, 96);
    DemPrintBarCode(hprinter,BARCODE_CODE128,"{A110123456789", 1, 60, TEXT_ALIGNMENT_LEFT, BARCODE_HRI_BELOW);


    //// print Barcode: Code13
    DemSetAbsolutePrintPosition(hprinter, 20);
    DemSetAbsoluteVerticalPrintPositionInPageMode(hprinter, 300);
    DemPrintBarCode(hprinter, BARCODE_EAN13, "2501138000002", 2, 60, TEXT_ALIGNMENT_LEFT, BARCODE_HRI_BELOW);


    // print QRCode
    DemSetAbsolutePrintPosition(hprinter,20);
    DemSetAbsoluteVerticalPrintPositionInPageMode(hprinter,400);
    DemPrintBarCode(hprinter,SYMBOL_QRCODE1,"QRCODE 1  654321",2, 60,TEXT_ALIGNMENT_LEFT,BARCODE_HRI_NONE);

    //// print QRCode
    DemSetAbsolutePrintPosition(hprinter, 220);
    DemSetAbsoluteVerticalPrintPositionInPageMode(hprinter, 400);
    DemPrintBarCode(hprinter, SYMBOL_QRCODE2, "QRCODE 2  123456", 2, 60, TEXT_ALIGNMENT_LEFT, BARCODE_HRI_NONE);


    // print PDF417
    DemSetAbsolutePrintPosition(hprinter,0);
    DemSetAbsoluteVerticalPrintPositionInPageMode(hprinter,950);
    DemPrintSymbol(hprinter,SYMBOL_STANDARD_PDF417, "China 0123456 ABC +_*&",PDF417_ERROR_CORRECTION_LEVEL_0,3,3,TEXT_ALIGNMENT_LEFT);

    //// print UPC-A
    DemSetAbsolutePrintPosition(hprinter, 20);
    DemSetAbsoluteVerticalPrintPositionInPageMode(hprinter,1150);
    DemPrintBarCode(hprinter, BARCODE_UPC_A, "023150456784", 2, 60, TEXT_ALIGNMENT_LEFT, BARCODE_HRI_BELOW);

    //// print UPC-E
    DemSetAbsolutePrintPosition(hprinter, 20);
    DemSetAbsoluteVerticalPrintPositionInPageMode(hprinter, 1350);
    DemPrintBarCode(hprinter, BARCODE_UPC_E, "01220000899", 2, 60, TEXT_ALIGNMENT_LEFT, BARCODE_HRI_BELOW);


    //// print EAN8
    DemSetAbsolutePrintPosition(hprinter, 20);
    DemSetAbsoluteVerticalPrintPositionInPageMode(hprinter, 1550);
    DemPrintBarCode(hprinter, BARCODE_EAN8, "1542656", 2, 60, TEXT_ALIGNMENT_LEFT, BARCODE_HRI_BELOW);

    //// print CODE39
    DemSetAbsolutePrintPosition(hprinter, 20);
    DemSetAbsoluteVerticalPrintPositionInPageMode(hprinter, 1850);
    DemPrintBarCode(hprinter, BARCODE_CODE39, "*10401YY00002009*", 2, 100, TEXT_ALIGNMENT_LEFT, BARCODE_HRI_BELOW);

    DemPrintAndReturnStandardMode(hprinter);

}

void PrintGetOtherNumber(void* hprinter)
{
    unsigned int number = 0;
    int result = 0;
    result = DemGetPaperFeedLinesNumber(hprinter, &number);
    if (number >= 0 && result == 0)
    {
        printf("GetPaperFeedLinesNumber = %d\r\n",number);
    }
    else
    {
        printf("GetPaperFeedLinesNumber fail = %d\r\n",result);
    }

    result = DemGetHeadEnergizingStrokesNumber(hprinter, &number);
    //AfxMessageBox("Printer state normal."));
    if (number >= 0 && result == 0)
    {
        printf("GetHeadEnergizingStrokesNumber = %d\r\n", number);
    }
    else
    {
        printf("GetHeadEnergizingStrokesNumber fail = %d\r\n", result);
    }

    //int clearType = 0;//\C7\E5\C0\ED\B2\CE\CA\FD0-3 \B7ֱ\F0\C7\E5\C0\ED\D7\DFֽ\D0\D0\CA\FD\A3\ACͷ\B2\BFͨ\B5\E7\CA\FD\A3\AC\D7Զ\AF\C7е\B6\B2\D9\D7\F7\CA\FD\A3\AC\B4\F2ӡ\BB\FA\B2\D9\D7\F7\D6\DC\C6\DA\CA\FD
    //result = DemClearPrinterMileage(hprinter, clearType);
    //if (result == 0)
    //{
    //	 printf("ClearPrinterMileage success\r\n"));
    //}
    //else
    //{
    //	printf("ClearPrinterMileage fail = %d\r\n", result);
    //}

    result = DemGetAutocutterOperationsNumber(hprinter, &number);
    if (number >= 0 && result == 0)
    {
        printf("GetAutocutterOperationsNumber = %d\r\n", number);
    }
    else
    {
        printf("GetAutocutterOperationsNumber fail = %d\r\n", result);
    }


    result = DemGetPrinterOperationPeriod(hprinter, &number);
    if (number >= 0 && result == 0)
    {
        printf("GetPrinterOperationPeriod = %d\r\n", number);
    }
    else
    {
        printf("GetPrinterOperationPeriod fail = %d\r\n", result);
    }

    //\B9\FD\CE±\A8\B4\ED\B4\CE\CA\FDͳ\BC\C6
    result = 8888;
    result = DemGetOverTemperatureErrorReportNumber(hprinter, &number);
    if (number >= 0 && result == 0)
    {
        printf("GetOverTemperatureErrorReportNumber = %d\r\n", number);
    }
    else
    {
        printf("GetOverTemperatureErrorReportNumber fail = %d\r\n", result);
    }

    //\B4\F2ӡ\B5\E3\CA\FD\B5\C4ͳ\BC\C6
    result = 8888;
    result = DemGetPrinterPointsNumber(hprinter, &number);
    if (number >= 0 && result == 0)
    {
        printf("GetPrinterPointsNumber = %d\r\n", number);
    }
    else
    {
        printf("GetPrinterPointsNumber fail = %d\r\n", result);
    }

    //\C7е\B6\B4\ED\CE\F3ͳ\BC\C6
    result = 8888;
    result = DemGetCutterErrorNumber(hprinter, &number);
    if (number >= 0 && result == 0)
    {
        printf("GetCutterErrorNumber = %d\r\n", number);
    }
    else
    {
        printf("GetCutterErrorNumber fail = %d\r\n", result);
    }

    //\C9ϵ翪\B8Ǵ\CE\CA\FDͳ\BC\C6
    result = 8888;
    result = DemGetPowerOnOpenCoverNumber(hprinter, &number);
    if (number >= 0 && result == 0)
    {
        printf("GetPowerOnOpenCoverNumber = %d\r\n", number);
    }
    else
    {
        printf("GetPowerOnOpenCoverNumber fail = %d\r\n", result);
    }

    //\B0\EB\C7д\CE\CA\FDͳ\BC\C6
    result = 8888;
    result = DemGetHalfCutNumber(hprinter, &number);
    if (number >= 0 && result == 0)
    {
        printf("GetHalfCutNumber = %d\r\n", number);
    }
    else
    {
        printf("GetHalfCutNumber fail = %d\r\n", result);
    }

    //ȫ\C7д\CE\CA\FDͳ\BC\C6
    result = 8888;
    result = DemGetTotalCutNumber(hprinter, &number);
    if (number >= 0 && result == 0)
    {
        printf("GetTotalCutNumber = %d\r\n", number);
    }
    else
    {
        printf("GetTotalCutNumber fail = %d\r\n", result);
    }

    //result = DemClearPrinterMileage2(hprinter);
    //if (result == 0)
    //{
    //	printf("ClearPrinterMileage2 = %d\r\n", number);
    //}
    //else
    //{
    //	printf("ClearPrinterMileage2 fail = %d\r\n", result);
    //}
}

//\B1\EA׼ָ\C1\BB\F1ȡ״̬
void PrinterState(void* hprinter)
{
	int state = 10;
	if (0 == DemGetPrinterState(hprinter, &state))
	{
		if (state == 0)
			printf("printer normal\r\n");
		else
			printf("printf abnormal\r\n");
	}
}

void DemoCodePageText(void* hprinter)
{

	//ʹ\D3\C3֮ǰ\BCǵù\A4\BE\DF\C9\E8\D6óɶ\E0\B9\FA\D3\EF\D1\D4
	//\C6\CF\CC\D1\D1\C0
	DemSetCodePage(hprinter, 860, 0);
	DemSetInternationalCharacter(hprinter, 1);
	const char arr[]={ 0x20,0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x0a,

	   0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x0a,

	   0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x0a,

	   0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x0a,

	   0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x0a,

	   0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 0x0a,

	   0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x0a,

	   0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f, 0x0a,

	   0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf, 0x0a,

	   0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf, 0x0a,

	   0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf, 0x0a,

	   0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf, 0x0a,

	   0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 0x0a,

	   0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0x3f, 0x0a,0x00 };
	
	DemPrintText(hprinter, arr, TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
	
//\B0\A2\C0\AD\B2\AE	
	DemSetCodePage(hprinter, 720, 0);
	DemSetInternationalCharacter(hprinter, 1);
	DemPrintText(hprinter, arr, TEXT_ALIGNMENT_LEFT, TEXT_NORMAL_MODE, TEXT_SIZE_0WIDTH | TEXT_SIZE_0HEIGHT);
	
}

void DemoGetVersionSN(void* hprinter)
{
	usleep(4000000);
	int version[3]={0};
	char arrSn[64] = { 0 };
	int snLenth = 0;
	{
		if (0 == DemGetFirmwareVersion(hprinter, version, 3))
		{
			printf("Printer FirmwareVersion:%d.%d.%d\r\n",version[0],version[1],version[2]);
		}
		else
		{
			printf("get Version fail\r\n");
		}
		if (0 == DemGetPrinterSN(hprinter, arrSn, &snLenth))
		{	
			printf("SN:");
			for (int i = 0; i < snLenth; i++)
			{
				printf("%c",arrSn[i]);
			}
			printf("\r\n");
		}
		else
		{
			printf("get SN fail\r\n");
		}
	}
}

//TP80l \D7Զ\A8\D2\E5״ָ̬\C1\EE
void DemoGetCustomPrinterState(void* hprinter)
{
	unsigned int state = -10;
	if (0 == DemGetCustomPrinterState(hprinter, &state))
	{
		if (state == 0)
			printf("printer normal\r\n");
		else
			printf("printf abnormal,state = %d\r\n",state);
	}
}

void DemGetPrinterMileage(void* hprinter)
{
	int number = 0;
	//获取加热里程
	int result = 8888;
if(DemGetPrinterHeatingMileage == NULL)
{
	printf("NULL POINT");
return 0;
}
	result = DemGetPrinterHeatingMileage(hprinter, &number);
	if (number >= 0 && result == 0)
	{
		printf(("DemGetPrinterHeatingMileage = %d\r\n"), number);
	}
	else
	{
		printf(("DemGetPrinterHeatingMileage fail = %d\r\n"), result);
	}

	//获取切刀里程
	result = 8888;
	result = DemGetPrinterFeedMileage(hprinter, &number);
	if (number >= 0 && result == 0)
	{
		printf(("DemGetPrinterFeedMileage = %d\r\n"), number);
	}
	else
	{
		printf(("DemGetPrinterFeedMileage fail = %d\r\n"), result);
	}

	//获取走纸里程
	result = 8888;
	result = DemGetPrinterCutterMileage(hprinter, &number);
	if (number >= 0 && result == 0)
	{
		printf(("DemGetPrinterCutterMileage = %d\r\n"), number);
	}
	else
	{
		printf(("DemGetPrinterCutterMileage fail = %d\r\n"), result);
	}
	
	//清除tp80l里程
	result = 8888;
	result = DemClearTP80LPrinterMileage(hprinter, 1);
	if (result == 0)
	{
		printf(("DemClearTP80LPrinterMileage success\r\n"));
	}
	else
	{
		printf(("DemClearTP80LPrinterMileage fail\r\n"), result);
	}
}

void upgradeTest(void* hprinter)
{
	//int ret = DemFirmwareOtaUpgrade(hprinter,"/home/jwj/jwj/linux_sdk(240913)/jwj_esc_domo/TP80L_V1.00.06_Beta1.bin","TP806","USB");
	int ret = DemFirmwareOtaUpgrade(hprinter,"/home/jwj/jwj/linux_sdk(240913)/jwj_esc_domo/TP80L_V1.00.08_Beta1.bin","TP806","USB");
	//int ret = DemFirmwareOtaUpgrade(hprinter,"/home/jwj/jwj/linux_sdk(240913)/jwj_esc_domo/TP80L_V1.00.05_Beta6.bin","TP806","USB");
	printf("update ret = %d\r\n", ret);
}

void densityTest(void* hprinter)
{
	int density = 0;
	int setdensity = 3;
	int ret = DemCustomGetDensity(hprinter, &density);
	printf("current density = %d\r\n", density);
	ret = DemCustomSetDensity(hprinter, setdensity);
	ret = DemCustomGetDensity(hprinter, &density);
	printf("density after change = %d\r\n", density);
}

void DirectIOTest(void* hprinter)
{
	char arr[3] = {0x1d,0x49,0x41};
	char readArr[64] = {0x00};
	int readNum = 0;
	int ret = DemDirectIO(hprinter,arr,sizeof(arr),readArr,sizeof(readArr),&readNum);
	printf("DemDirectIO ret = %d,readNum=%d",ret,readNum);
	for(int i=0;i<readNum;i++)
	{
		printf("%c",readArr[i]);
	}
	printf("\r\n");
}

void PageSpeedTest(void* hprinter)
{
	int speed = -1;
	int ret = DemRetrievePreviousPageSpeed(hprinter,&speed);
	printf("PageSpeedTest ret = %d,speed = %d\n",ret,speed);
}

int main()
{
    Test_esc();
    return 0;
}
