﻿#ifndef _SDK_COMMON_API_H
#define _SDK_COMMON_API_H

#ifndef HPRT_STATIC_LIB
#   ifdef LINUX

#       define SDK_API __attribute__ ( (visibility( "default" ) ) )
#       define CALL_STACK
#       define TCHAR char

#   else

//#       include <tchar.h>
#       define TCHAR char

#	ifdef EXPORT_CDECL
#		define CALL_STACK __cdecl
#	else
#		define CALL_STACK __stdcall	//windows default
#	endif
#	ifndef SDK_API
#		ifdef __cplusplus
#			define SDK_API extern "C" //__declspec( dllexport )  --- 使用模块定义文件.
#		else
#			define SDK_API //__declspec( dllexport )
#		endif
#	endif


#   endif   //LINUX

#else
#       define SDK_API      //extern "C"
#       define CALL_STACK
#       define TCHAR char
#endif  //HPRT_STATIC_LIB

#if defined __MINGW32__
    #pragma message("__MINGW32__")
    #ifdef __cplusplus
        #define SDK_API extern "C" __declspec(dllexport)
        #pragma message("__cplusplus")
    #else
        #define SDK_API __declspec(dllexport)
        #pragma message("ccc")
    #endif
#endif

#ifdef __cplusplus
extern"C"
{
#endif

SDK_API void CALL_STACK FormatError( int errorNo, int langid, unsigned char* buf, int pos, int bufSize );

SDK_API int CALL_STACK PrinterCreator( void** phandle, const TCHAR* model );

SDK_API int CALL_STACK SetLog(int enable, const TCHAR* path);

SDK_API void* CALL_STACK PrinterCreatorS(const TCHAR* model );

SDK_API int CALL_STACK PrinterDestroy( void* handle );

//==================================
//windows上：[见hprt_io_windows.c]
//	串口："COM1,115200,n,8,1,n"		依次是：串口号、波特率，校验位，数据位，停止位，握手/流控
//  USB自动匹配： "USB"									//支持自动匹配我们的打印机
//	USB："USB,Port_#0008.Hub_#0001"						//连接指定的打印机【第二个参数不可加型号，它是用于存放设备总线路径的】
//	USB："USB,vid=0x20d1,pid=0x7007"                    //连接指定的打印机   新增支持的格式 by wjz 20230216
//	NET: "NET,127.0.0.1,9100"
//	BT:	"BT,127.0.0.1,1234"
//================================
//linux上：[见hprt_io_linux.c]
//	串口："COM=ttyS1,115200"
//	USB："USB,设备名如USBPrinter"
//	USB："USB,HN-3208SR,vid=0x18d1,pid=0x010b"			//连接指定的打印机【第二个参数必须加型号】
//  USB："USB,bus=003,addr=24"                          //连接指定的打印机
//	NET: "NET,IP=127.0.0.1,PORT=9100"
//==================================
/*
linux上课设置的参数比较少。形式也不尽相同，全部都是字符串形式
windows上，串口可设置参数有：
	波特率：2400,4800,9600,19200,38400,57600,115200  
	校验位：n,o,e,m.s		分别对应no,odd,even,mark,space
	数据位：4,5,6,7,8
	停止位："1","1.5","2"
	流控："p","c","d","x","n"	详见“hprt_io_serial_windows.c”

linux上只支持设置波特率同上

*/
//================================
SDK_API int CALL_STACK PortOpen( void* handle, const TCHAR* ioSettings );

SDK_API int CALL_STACK DriverPortOpen( void* handle, const TCHAR* driverName );

SDK_API int CALL_STACK PortClose( void* handle );

SDK_API int CALL_STACK DirectIO( void* handle, unsigned char* writeData, unsigned int writeNum, unsigned char* readData, unsigned int readNum, unsigned int* preadedNum );

SDK_API int CALL_STACK WriteData( void* handle, unsigned char* writeData, unsigned int writeNum );

SDK_API int CALL_STACK ReadData( void* handle, unsigned char* readData, unsigned int readNum, unsigned int* preadedNum );

SDK_API int CALL_STACK GetUsbList(const TCHAR* cUsbList, int buf_size, int* pcnt, int type);
#if defined(_WIN32) || defined(_WIN64) 
SDK_API int CALL_STACK ReadDataClean(void* handle, unsigned char* readData, unsigned int readNum, unsigned int* preadedNum,unsigned int constanttimeout);
#endif

SDK_API int CALL_STACK ReadDataEOF( void* handle,
                                    unsigned char* readData, unsigned int offSet, unsigned int bufLength,
                                    unsigned char soh, unsigned char eof,
                                    unsigned int* preadedNum);

SDK_API int CALL_STACK SendCommand( void* handle, char* writeData);

//add by wjz 20220517
SDK_API int CALL_STACK ReadDataExist(void* handle,
	unsigned char* readData, unsigned int offSet, unsigned int bufLength,
	unsigned char* soh, unsigned char* eof,
	unsigned int* preadedNum,
	int trytimes);

//add by wjz 20220517 ddccbbaa字库下载
SDK_API int CALL_STACK DownloadFontFile(void* handle, int iPacketSize, char* filename, char* desc, void* pfnDownProgress);
SDK_API int CALL_STACK downloadYModem(void* handle, char* filename, char* desc, void* fn);
SDK_API int CALL_STACK DownloadFMWImg(void* handle, char* filename, char* desc, void* pfnDownProgress);
SDK_API void CALL_STACK setCancel();

#if defined(_WIN32) || defined(_WIN64)
SDK_API int CALL_STACK GetVidPid(unsigned char* buf);
#endif

//add by wjz 20230216 获取设备连接信息 
SDK_API int CALL_STACK GetUriOption(void* handle, char* key, char* value, int buflen);

#ifdef __cplusplus
}
#endif

#endif
