#ifndef _ESC_SDK_API_H_
#define _ESC_SDK_API_H_

#include "sdk_common_api.h"

#define SDK_VERSION     "1,4,1,5"

SDK_API int CALL_STACK PrinterInitialize(void* handle);
SDK_API int CALL_STACK FeedLine(void* handle,int lines);
SDK_API int CALL_STACK SetAlign(void* handle, int align);
SDK_API int CALL_STACK PrintText(void* handle,const TCHAR* data,int alignment,int attribute,int textSize);
SDK_API int CALL_STACK PrintTextS(void* handle,const TCHAR* data);
SDK_API int CALL_STACK PrintBarCode(void* handle,int bcType, const TCHAR* data,int width,int height,int alignment,int hriPosition);
SDK_API int CALL_STACK PrintSymbol(void* handle,int type, const TCHAR* data,int errLevel,int width,int height,int alignment);

SDK_API int CALL_STACK CutPaper(void* handle,int cutMode,int distance);
//add by wjz 20210510
SDK_API int CALL_STACK CutPaperOnly(void* handle, int cutMode);
SDK_API int CALL_STACK OpenCashDrawer(void* handle,int pinMode,int onTime,int offTime);
SDK_API int CALL_STACK SelectStandardMode(void* handle);
SDK_API int CALL_STACK SetTextLineSpace(void* handle,int lineSpace);
SDK_API int CALL_STACK SetTextBold(void* handle, int bold);
SDK_API int CALL_STACK SetTextFont(void* handle, int font);
SDK_API int CALL_STACK SelectPageMode(void* handle);
SDK_API int CALL_STACK SetPrintAreaInPageMode(void* handle,int horizontal,int vertical,int width,int height);
SDK_API int CALL_STACK CancelPrintDataInPageMode(void* handle);
SDK_API int CALL_STACK SelectPrintDirectionInPageMode(void* handle,int direction);
SDK_API int CALL_STACK SetAbsolutePrintPosition(void* handle, int position);
SDK_API int CALL_STACK SetAbsoluteVerticalPrintPositionInPageMode(void* handle,int position);
SDK_API int CALL_STACK PrintAndReturnStandardMode(void* handle);
SDK_API int CALL_STACK PositionNextLabel(void* handle);
SDK_API int CALL_STACK PrintDataInPageMode(void* handle);
SDK_API int CALL_STACK GetPrinterState(void* handle,unsigned int* printerStatus);
SDK_API int CALL_STACK GetCustomPrinterState(void* handle, unsigned int* printerStatus);
SDK_API int CALL_STACK SetHorizontalAndVerticalMotionUnits(void* handle, int horizontal, int vertical);
SDK_API int CALL_STACK SetCodePage(void* handle,int codepage,int type);
SDK_API int CALL_STACK SetBuzzer(void* handle,int enable);
SDK_API int CALL_STACK SetInternationalCharacter(void* handle,int characterSet);
SDK_API int CALL_STACK SetPrintSpeed(void* handle,int speed);
SDK_API int CALL_STACK PrintDataMatrixCode(void* handle, int rotation,/*int dotSize,*/int barcodeSize, const TCHAR* data,int dataSize);

//Print Image

SDK_API int CALL_STACK PrintNVImageCompatible(void* handle, int imgNo, int scaleMode);
SDK_API int CALL_STACK PrintDownloadedImageCompatible(void* handle, int scaleMode);

SDK_API int CALL_STACK PrintImage(void* handle,const TCHAR* imagePath,int scaleMode);
SDK_API int CALL_STACK DefineNVImage(void* handle,const TCHAR* imagePath,unsigned char kc1,unsigned char kc2);
SDK_API int CALL_STACK PrintNVImage(void* handle,unsigned char kc1,unsigned char kc2);
SDK_API int CALL_STACK DefineDownloadedImage(void* handle,const TCHAR* imagePath,unsigned char kc1,unsigned char kc2);
SDK_API int CALL_STACK PrintDownloadedImage(void* handle, unsigned char kc1, unsigned char kc2);
SDK_API int CALL_STACK DefineBufferedImage(void* handle,const TCHAR* imagePath);
SDK_API int CALL_STACK PrintBufferedImage(void* handle);
SDK_API int CALL_STACK DeleteAllNVImages(void* handle);

SDK_API int CALL_STACK GetFirmwareVersion(void* handle,int* version,int versionLen);
SDK_API int CALL_STACK GetCashDrawerState(void* handle, int* drawerState);
SDK_API int CALL_STACK ClearBuffer(void* handle);
SDK_API int CALL_STACK PrintBitMapData(void* handle, int scaleMode, int width, int height, unsigned char* data);
SDK_API int CALL_STACK PrintTwoQRCode(void* handle, const TCHAR* data1, int width1, int hAlign1, int vAlign1, const TCHAR* data2, int width2, int hAlign2, int vAlign2);
SDK_API int CALL_STACK PrintTwoQRCodeS(void* handle, int height, TCHAR* data1, TCHAR* data2);

SDK_API int CALL_STACK DrawLine(void* handle, int xStart, int yStart, int xEnd, int yEnd, int lineWidth);
SDK_API int CALL_STACK DrawRectangle(void* handle, int xStart, int yStart, int xArea, int yArea, int lineWidth);


SDK_API int CALL_STACK FirmwareUpgrade(void* handle,const TCHAR* cFileName,const char* model,const char* ioSettings);


SDK_API int CALL_STACK GetDrawerState(void* handle, int* drawerState);
SDK_API int CALL_STACK OpenDrawer(void* handle, int pinMode, int onTime, int offTime);

//=========================== add by wjz 20210512

//봫gbkı
SDK_API int CALL_STACK PrintReceipt(void* handle
	, int	cn_font											//
	, int	en_font											//Ӣ
	, const char* licence_plate								//ƺ + ɫ	
	, const char* entrance
	, const char* entrance_time
	, const char* exit
	, const char* exit_time
	, const char* money
	, int qrcode_width
	, int qrcode_errlevel
	, const char* qrcode
	, const char* custom_text
	, const char* phone
	, int cutMode);

//ӡԼҳ add by wjz 20210511
SDK_API int CALL_STACK PrintDemoPage(void* handle);

SDK_API int CALL_STACK SetEthernetInfo(void* handle, int mode, const char* ip, const char*  ipmask, const char* gateway);
SDK_API int CALL_STACK GetEthernetInfo(void* handle, int* mode, char* ip, char*  ipmask, char* gateway, char* macaddress);

//ôӡŨ
SDK_API int CALL_STACK SetDensity(void* handle, int density);
//е
SDK_API int CALL_STACK SetCutter(void* handle, int enable);
//÷
SDK_API int CALL_STACK SetBuzzer2(void* handle, int buzzer);
//ôϢ
SDK_API int CALL_STACK SetSerialportInfo(void* handle, int baudrate, int bytesize, int parity, int stopbit, int flowctrl);

//ȡӡŨ
SDK_API int CALL_STACK GetDensity(void* handle, int* density);
//ȡе
SDK_API int CALL_STACK GetCutter(void* handle, int* enable);
//ȡ
SDK_API int CALL_STACK GetBuzzer2(void* handle, int* buzzer);
//ȡϢ
SDK_API int CALL_STACK GetSerialportInfo(void* handle, int* baudrate, int* bytesize, int* parity, int* stopbit, int* flowctrl);

//ģ鸴λ
SDK_API int CALL_STACK EncryptionModuleNumberReset(void* handle);

//ȡģ
SDK_API int CALL_STACK GetEncryptionModuleNumber(void* handle, char* buf, int len, int* reallen);

//÷
SDK_API int CALL_STACK SetBuzzerVolume(void* handle, int volume);

//ȡ
SDK_API int CALL_STACK GetBuzzerVolume(void* handle, int* volume);

//ֽ
SDK_API int CALL_STACK SetCheckLabelRunout(void* handle, int enable);

//
SDK_API int CALL_STACK SetFontCN(void* handle, int font);

SDK_API int CALL_STACK Test(void* handle);

//==========================================
//add by wjz 20211110
SDK_API int CALL_STACK PrintImageStream(void* handle, const char* stream, int len, int scaleMode);
SDK_API int CALL_STACK DefineNVImageStream(void* handle, const char* stream, int len, unsigned char kc1, unsigned char kc2);
SDK_API int CALL_STACK DefineDownloadedImageStream(void* handle, const char* stream, int len, unsigned char kc1, unsigned char kc2);
SDK_API int CALL_STACK DefineBufferedImageStream(void* handle, const char* stream, int len);

#ifndef LINUX

SDK_API int CALL_STACK DefineDownloadedImageStreamCompatible(void* handle, const char* stream, int len);
SDK_API int CALL_STACK DefineDownloadedImageCompatible(void* handle, const TCHAR* fileName);
SDK_API int CALL_STACK DefineNVImageCompatible(void* handle, const TCHAR** fileNameList, int imageQty);
//add by wjz 20240328
SDK_API int CALL_STACK AddBitImage(void* handle, const TCHAR* filename, int density);

SDK_API int CALL_STACK AddBitImageEx(void* handle, const TCHAR* filename, int density, int x, int y);

#endif

//CDE-110
SDK_API int CALL_STACK SetLed(void* handle, int lightType, int mode);

SDK_API int CALL_STACK GetPrinterSN(void* handle, char* sn, int* snLenth);

//TP808S
SDK_API int CALL_STACK GetPaperFeedLinesNumber(void* handle, unsigned int *number);
SDK_API int CALL_STACK GetHeadEnergizingStrokesNumber(void* handle, unsigned int *number);
//ͳֵָ1
SDK_API int CALL_STACK ClearPrinterMileage(void* handle,int clearType);
SDK_API int CALL_STACK GetAutocutterOperationsNumber(void* handle, unsigned int *number);
SDK_API int CALL_STACK GetPrinterOperationPeriod(void* handle, unsigned int *period);

//±ͳ  808ר
SDK_API int CALL_STACK GetOverTemperatureErrorReportNumber(void* handle, unsigned int *number);

//ӡͳ 808ר
SDK_API int CALL_STACK GetPrinterPointsNumber(void* handle, unsigned int *number);

//еͳ 808ר
SDK_API int CALL_STACK GetCutterErrorNumber(void* handle, unsigned int *number);

//ϵ翪Ǵͳ 808ר
SDK_API int CALL_STACK GetPowerOnOpenCoverNumber(void* handle, unsigned int *number);

//дͳ 808ר
SDK_API int CALL_STACK GetHalfCutNumber(void* handle, unsigned int *number);

//ȫдͳ 808ר
SDK_API int CALL_STACK GetTotalCutNumber(void* handle, unsigned int *number);

//ͳֵָ2 808ר
SDK_API int CALL_STACK ClearPrinterMileage2(void* handle);

#define CUSTOM
#ifdef CUSTOM
//Ƽģ
SDK_API int CALL_STACK GenerateReceipt(void* handle, int printHorizontal, int printVertical, int width, int height, int font,
	int textsize1, int absolutePosition1, int verticalPosition1, const char* data1, int data1Lenth,
	int textsize2, int absolutePosition2, int verticalPosition2, const char* data2, int data2Lenth,
	int textsize3, int absolutePosition3, int verticalPosition3, const char* data3, int data3Lenth,
	int textsize4, int absolutePosition4, int verticalPosition4, const char* data4, int data4Lenth,
	int qrcodeAbsolutePosition, int qrcodeVerticalPosition, unsigned char qrmodel, unsigned char qrErrorLevel, unsigned char qrSize, const char* qrdata, int qrLenth, int cutModel,int distance);

SDK_API int CALL_STACK CustomSetLaberAttribute(void* handle, int printHorizontal, int printVertical, int width, int height, int font);

SDK_API int CALL_STACK CustomPrintText(void* handle, int textsize1, int absolutePosition, int verticalPosition, const char* data, int data1Lenth);

SDK_API int CALL_STACK CustomPrintQRcode(void* handle, int qrcodeAbsolutePosition, int qrcodeVerticalPosition, unsigned char qrmodel, unsigned char qrErrorLevel, unsigned char qrSize, const char* qrdata, int qrLenth);

SDK_API int CALL_STACK CustomPrintErrorRetype(void* handle, const TCHAR* data, int alignment, int attribute, int textSize);
#endif

SDK_API int CALL_STACK FirmwareOtaUpgrade(void* handle,const TCHAR* cFileName,const TCHAR* model,const TCHAR* ioSettings);

#ifndef LINUX
SDK_API int CALL_STACK FontDownload(void* handle,const TCHAR* cFileName,const TCHAR* model,const TCHAR* ioSettings);
#endif

SDK_API int CALL_STACK GetSDKVersion(char* buffer, int len);

//ȡ 80l
SDK_API int CALL_STACK GetPrinterHeatingMileage(void* handle, unsigned int *number);

//ȡֽ 80l
SDK_API int CALL_STACK GetPrinterFeedMileage(void* handle, unsigned int *number);

//ȡе 80l
SDK_API int CALL_STACK GetPrinterCutterMileage(void* handle, unsigned int *number);

// 80l
SDK_API int CALL_STACK ClearTP80LPrinterMileage(void* handle,int clearType);

//
SDK_API int CALL_STACK SetResetPrinter(void* handle);

SDK_API int CALL_STACK CustomSetDensity(void* handle,int density);
SDK_API int CALL_STACK CustomGetDensity(void* handle, int *density);

//tp80l ȡ״̬ 
SDK_API int CALL_STACK GetTaskFinishStatus(void* handle, unsigned int *status);


SDK_API int CALL_STACK RetrievePreviousPageSpeed(void* handle, int* speed);
#endif /*WIN32_SDK_H*/
