package com.sdk.esc;

import android.app.Dialog;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;

import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;

public class NetworkConfigDialogFragment extends DialogFragment {

   private OnNetworkConfigListener listener;

   public void setOnNetworkConfigListener(OnNetworkConfigListener listener) {
      this.listener = listener;
   }

   @Override
   public Dialog onCreateDialog(Bundle savedInstanceState) {
      View view = LayoutInflater.from(getContext()).inflate(R.layout.dialog_network_config, null);
      RadioGroup networkTypeGroup = view.findViewById(R.id.networkTypeGroup);
      RadioButton ethernetRadio = view.findViewById(R.id.ethernetRadio);
      RadioButton wifiRadio = view.findViewById(R.id.wifiRadio);

      LinearLayout wifiModeLayout = view.findViewById(R.id.wifiModeLayout);
      RadioGroup wifiModeGroup = view.findViewById(R.id.wifiModeGroup);
      RadioButton staRadio = view.findViewById(R.id.staRadio);
      RadioButton apRadio = view.findViewById(R.id.apRadio);

      CheckBox dhcpCheckbox = view.findViewById(R.id.dhcpCheckbox);
      LinearLayout dhcpLayout = view.findViewById(R.id.dhcpLayout);
      LinearLayout ipConfigLayout = view.findViewById(R.id.ipConfigLayout);

      EditText ipEdit = view.findViewById(R.id.ipEdit);
      EditText gatewayEdit = view.findViewById(R.id.gatewayEdit);
      EditText maskEdit = view.findViewById(R.id.maskEdit);

      LinearLayout staLayout = view.findViewById(R.id.staLayout);
      EditText staSsidEdit = view.findViewById(R.id.staSsidEdit);
      EditText staPasswordEdit = view.findViewById(R.id.staPasswordEdit);
      EditText staEncryptEdit = view.findViewById(R.id.staEncryptEdit);

      LinearLayout apLayout = view.findViewById(R.id.apLayout);
      EditText apSsidEdit = view.findViewById(R.id.apSsidEdit);
      CheckBox apPwdCheckbox = view.findViewById(R.id.apPwdCheckbox);
      EditText apPasswordEdit = view.findViewById(R.id.apPasswordEdit);

      // 控制视图显示逻辑
      Runnable updateVisibility = () -> {
         boolean isEthernet = ethernetRadio.isChecked();
         boolean isWiFi = wifiRadio.isChecked();
         boolean isSta = staRadio.isChecked();
         boolean isAp = apRadio.isChecked();
         boolean useDhcp = dhcpCheckbox.isChecked();
         boolean apNeedPwd = apPwdCheckbox.isChecked();

         wifiModeLayout.setVisibility(isWiFi ? View.VISIBLE : View.GONE);
         dhcpLayout.setVisibility(isEthernet || (isWiFi && isSta) ? View.VISIBLE : View.GONE);
         ipConfigLayout.setVisibility(!useDhcp && (isEthernet || (isWiFi && isSta)) ? View.VISIBLE : View.GONE);
         staLayout.setVisibility(isWiFi && isSta ? View.VISIBLE : View.GONE);
         apLayout.setVisibility(isWiFi && isAp ? View.VISIBLE : View.GONE);
         apPasswordEdit.setVisibility(apNeedPwd ? View.VISIBLE : View.GONE);
      };

      networkTypeGroup.setOnCheckedChangeListener((group, checkedId) -> updateVisibility.run());
      wifiModeGroup.setOnCheckedChangeListener((group, checkedId) -> updateVisibility.run());
      dhcpCheckbox.setOnCheckedChangeListener((buttonView, isChecked) -> updateVisibility.run());
      apPwdCheckbox.setOnCheckedChangeListener((buttonView, isChecked) -> updateVisibility.run());

      return new AlertDialog.Builder(requireContext())
              .setTitle(getString(R.string.dialog_title))
              .setView(view)
              .setPositiveButton(getString(R.string.confirm), (dialog, which) -> {
                 NetworkConfig config = new NetworkConfig();

                 if (ethernetRadio.isChecked()) {
                    config.type = "ethernet";
                    config.dhcp = dhcpCheckbox.isChecked();
                    if (!config.dhcp) {
                       config.ip = ipEdit.getText().toString();
                       config.gateway = gatewayEdit.getText().toString();
                       config.mask = maskEdit.getText().toString();
                    }
                 } else if (wifiRadio.isChecked()) {
                    config.type = "wifi";
                    boolean isSta = staRadio.isChecked();
                    config.wifiMode = isSta ? "sta" : "ap";

                    if (isSta) {
                       config.ssid = staSsidEdit.getText().toString();
                       config.password = staPasswordEdit.getText().toString();
                       config.encryption = staEncryptEdit.getText().toString();
                       config.dhcp = dhcpCheckbox.isChecked();
                       if (!config.dhcp) {
                          config.ip = ipEdit.getText().toString();
                          config.gateway = gatewayEdit.getText().toString();
                          config.mask = maskEdit.getText().toString();
                       }
                    } else {
                       config.ssid = apSsidEdit.getText().toString();
                       config.passwordRequired = apPwdCheckbox.isChecked();
                       if (config.passwordRequired) {
                          config.password = apPasswordEdit.getText().toString();
                       }
                    }
                 }

                 if (listener != null) {
                    listener.onNetworkConfigResult(config);
                 }

              })
              .setNegativeButton(getString(R.string.cancel), null)
              .create();
   }
}

