package com.sdk.esc;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.prt.esc.listener.SearchPrinterListener;
import com.prt.esc.listener.SetConfigListener;
import com.prt.esc.mode.EthernetData;
import com.prt.esc.mode.WifiAPData;
import com.prt.esc.mode.WifiSTAData;
import com.prt.esc.utils.LanConfigUtil;
import com.prt.udplibrary.data.Printer;

import java.util.ArrayList;

public class LanConfigActivity extends AppCompatActivity {

    private BaseQuickAdapter<Printer, BaseViewHolder> baseQuickAdapter;
    private RecyclerView rvPrinter;
    private Button btnSearch;
    private ArrayList<Printer> list;
    private Context mContext;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_lan_config);
        mContext = getApplicationContext();
        rvPrinter = findViewById(R.id.rvPrinter);
        btnSearch = findViewById(R.id.btnSearch);
        list = new ArrayList<Printer>();
        baseQuickAdapter = new BaseQuickAdapter<Printer, BaseViewHolder>(android.R.layout.simple_list_item_2, list) {

            @Override
            protected void convert(BaseViewHolder helper, Printer item) {
                helper.setText(android.R.id.text1, item.getPrinterName());
                helper.setText(android.R.id.text2, item.getSn() + "\n" + item.getIp());
            }
        };
        rvPrinter.setLayoutManager(new LinearLayoutManager(mContext));
        rvPrinter.addItemDecoration(new DividerItemDecoration(mContext, DividerItemDecoration.VERTICAL));
        rvPrinter.setAdapter(baseQuickAdapter);
        baseQuickAdapter.setOnItemClickListener((adapter, view, position) -> {
            NetworkConfigDialogFragment dialog = new NetworkConfigDialogFragment();
            dialog.setOnNetworkConfigListener(config -> {
                Log.d("NetworkConfig", "类型: " + config.type);
                if ("ethernet".equals(config.type)) {
                    if (!config.dhcp) {
                        Log.d("NetworkConfig", "IP: " + config.ip + ", 网关: " + config.gateway + ", 掩码: " + config.mask);
                    }
                    LanConfigUtil.setEthernetConfig(list.get(position), new EthernetData(config.dhcp, config.ip, config.mask, config.gateway), result -> Log.d("NetworkConfig", "result: " + result));
                } else if ("wifi".equals(config.type)) {
                    Log.d("NetworkConfig", "WiFi模式: " + config.wifiMode + ", SSID: " + config.ssid);
                    if ("ap".equals(config.wifiMode)){
                        LanConfigUtil.setWifiApConfig(list.get(position), new WifiAPData(config.ssid, !config.passwordRequired, config.password), result -> {
                            Log.d("NetworkConfig", "result: " + result);
                        });
                    }else{
                        LanConfigUtil.setWifiStaConfig(list.get(position), new WifiSTAData(config.ssid, config.encryption, config.password, config.dhcp, config.ip, config.gateway, config.mask), result -> {
                            Log.d("NetworkConfig", "result: " + result);
                        });
                    }
                }
            });
            dialog.show(getSupportFragmentManager(), "network_config");
        });
        btnSearch.setOnClickListener(v -> {
            list.clear();
            baseQuickAdapter.notifyDataSetChanged();
            LanConfigUtil.searchPrinter(printer -> {
                if (printer != null){
                    if (!list.contains(printer)){
                        list.add(printer);
                        baseQuickAdapter.notifyDataSetChanged();
                    }
                }
            });
        });
    }
}