package com.sdk.esc;

import android.Manifest;
import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import android.util.Log;


import androidx.appcompat.app.AppCompatActivity;

import com.tbruyelle.rxpermissions2.RxPermissions;



/**
 * Created by NO on 2018/7/24.
 */

public class Bluetooth {
    Context context;
    static Bluetooth bluetooth;
    private BluetoothAdapter mBluetoothAdapter;
    BTScanListener btScanListener;
    private static RxPermissions rxPermissions;

    private Bluetooth(Context context) {
        this.context = context;
    }

    public static Bluetooth getBluetooth(Context context) {
        bluetooth = new Bluetooth(context);
        return bluetooth;
    }

    private void registerBroadcast() {
        IntentFilter intent = new IntentFilter();
        intent.addAction(BluetoothDevice.ACTION_FOUND);// 用BroadcastReceiver来取得搜索结果
        intent.addAction(BluetoothDevice.ACTION_BOND_STATE_CHANGED);
        intent.addAction(BluetoothAdapter.ACTION_DISCOVERY_FINISHED);
        context.registerReceiver(mReceiver, intent);
    }

    @SuppressLint("MissingPermission")
    public void doDiscovery() {
        if (context != null) {
            mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (mBluetoothAdapter == null) {
                Utility.show(context, "Device does not support Bluetooth");
                return;
            } else if (!mBluetoothAdapter.isEnabled()) {
                mBluetoothAdapter.enable();
            }
            registerBroadcast();
            rxPermissions = new RxPermissions((AppCompatActivity) context);
            rxPermissions.request(Manifest.permission.BLUETOOTH_ADMIN,
                    Manifest.permission.BLUETOOTH,
                    Manifest.permission.ACCESS_FINE_LOCATION).subscribe(aBoolean -> {
                if (aBoolean) {
                    if (null == mBluetoothAdapter) {
                        mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                    }
                    if (!mBluetoothAdapter.isEnabled()) {
                        mBluetoothAdapter.enable();
                    }
                    if (mBluetoothAdapter.isDiscovering()) {
                        mBluetoothAdapter.cancelDiscovery();
                    }
                    mBluetoothAdapter.startDiscovery();
                } else {
                    Utility.show(context, "no bluetooth permission");
                }
            });
        }
    }

    public void setBTScanListener(BTScanListener listener) {
        btScanListener = listener;
    }

    public interface BTScanListener {
        public void succeed(String btName, String btMac);
    }

    @SuppressLint("MissingPermission")
    public void disReceiver() {
        if (mReceiver != null && context != null)
            context.unregisterReceiver(mReceiver);
        if (mBluetoothAdapter.isDiscovering())
            mBluetoothAdapter.cancelDiscovery();
    }

    private final BroadcastReceiver mReceiver = new BroadcastReceiver() {
        @SuppressLint("MissingPermission")
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            BluetoothDevice device = null;
            switch (action) {
                case BluetoothDevice.ACTION_FOUND:
                    device = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
                    if (device.getBluetoothClass().getMajorDeviceClass() == 1536) {
                        if (btScanListener != null) {
                            btScanListener.succeed(TextUtils.isEmpty(device.getName()) ? "UnKnown" : device.getName(), device.getAddress());
                        }
                    }
                    break;
                case BluetoothDevice.ACTION_BOND_STATE_CHANGED:
                    device = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
                    switch (device.getBondState()) {
                        case BluetoothDevice.BOND_BONDING:
                            Log.d("Print", "正在配对......");
                            break;
                        case BluetoothDevice.BOND_BONDED:
                            Log.d("Print", "完成配对");
                            break;
                        case BluetoothDevice.BOND_NONE:
                            Log.d("Print", "取消配对");
                        default:
                            break;
                    }
                    break;
                case BluetoothAdapter.ACTION_DISCOVERY_FINISHED:
                    Log.d("Print", "搜索完成");
                    break;
            }
            if (BluetoothDevice.ACTION_FOUND.equals(action)){

            }
        }
    };
}
