package com.sdk.esc;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.RelativeLayout;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;

import java.util.ArrayList;
import java.util.List;


public class BTActivity extends AppCompatActivity {

    private Context mContext;
    public BluetoothAdapter myBluetoothAdapter;
    private Intent intent;
    private BaseQuickAdapter<PrintBT, BaseViewHolder> baseQuickAdapter;
    private Bluetooth bluetooth;
    private List<PrintBT> list;
    private int tag;
    private RecyclerView recyHistory;
    private SwipeRefreshLayout swipeRefresh;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_bt);
        mContext = getApplicationContext();
        recyHistory = findViewById(R.id.recy_history);
        swipeRefresh = findViewById(R.id.swipe_refresh);
        initData();
    }

    private void initData() {
        intent = getIntent();
        tag = intent.getIntExtra("TAG", RESULT_CANCELED);
        ListBluetoothDevice();
    }
    @SuppressLint("MissingPermission")
    public void ListBluetoothDevice() {
        if ((myBluetoothAdapter = BluetoothAdapter.getDefaultAdapter()) == null) {
            Toast.makeText(this, "没有找到蓝牙适配器", Toast.LENGTH_LONG).show();
            return;
        }

        if (!myBluetoothAdapter.isEnabled()) {
            Intent enableBtIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
            startActivityForResult(enableBtIntent, 2);
        }
        list = new ArrayList<PrintBT>();
        baseQuickAdapter = new BaseQuickAdapter<PrintBT, BaseViewHolder>(android.R.layout.simple_list_item_2, list) {

            @Override
            protected void convert(BaseViewHolder helper, PrintBT item) {
                helper.setText(android.R.id.text1, item.getBtName());
                helper.setText(android.R.id.text2, item.getBtMac());
            }
        };
        recyHistory.setLayoutManager(new LinearLayoutManager(mContext));
        recyHistory.addItemDecoration(new DividerItemDecoration(mContext, DividerItemDecoration.VERTICAL));
        recyHistory.setAdapter(baseQuickAdapter);
        bluetooth = Bluetooth.getBluetooth(this);
        initBT();
        baseQuickAdapter.setOnItemClickListener((adapter, view, position) -> {
            Intent intent = new Intent();
            intent.putExtra("SelectedBDAddress", list.get(position).getBtMac());
            setResult(tag, intent);
            finish();
        });
        swipeRefresh.setColorSchemeResources(R.color.colorPrimary);
        swipeRefresh.setOnRefreshListener(() -> {
            initBT();
            if (swipeRefresh.isRefreshing())
                swipeRefresh.setRefreshing(false);
        });
    }

    private void initBT() {
        list.clear();
        baseQuickAdapter.notifyDataSetChanged();
        bluetooth.doDiscovery();
        bluetooth.setBTScanListener((btName, btMac) -> {
            for (PrintBT printBT : list) {
                if (btMac.equals(printBT.getBtMac())) {
                    return;
                }
            }
            PrintBT printBT = new PrintBT();
            printBT.setBtName(btName);
            printBT.setBtMac(btMac);
            list.add(printBT);
            baseQuickAdapter.notifyDataSetChanged();
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        bluetooth.disReceiver();
    }
}
