package com.sdk.esc;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.prt.esc.PrinterHelper;
import com.prt.esc.printer.Printer;
import com.prt.esc.printer.PublicFunction;


public class Activity_Wifi extends Activity {
    private Context thisCon = null;
    private EditText edtIP = null;
    private EditText edtPort = null;
    private TextView txtTips = null;
    private ProgressBar pro_bar;
    private PublicFunction publicFunction;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
        setContentView(R.layout.activity_wifi);
        thisCon = this.getApplicationContext();
        publicFunction = new PublicFunction(thisCon);
        edtIP = (EditText) findViewById(R.id.txtIPAddress);
        edtPort = (EditText) findViewById(R.id.txtWifiPort);
        txtTips = (TextView) findViewById(R.id.txtTips);
        pro_bar = (ProgressBar) findViewById(R.id.pro_bar);
        String ip = publicFunction.readSharedPreferencesData("IP");
        if (!ip.isEmpty()){
            edtIP.setText(ip);
        }
    }

    public void onClickConnect(View view) {
        if (!CheckClick.isClickEvent()) return;

        try {
            final String strIP = edtIP.getText().toString().trim();
            final String strPort = edtPort.getText().toString().trim();
            if (strIP.length() == 0) {
                Toast.makeText(thisCon, R.string.activity_wifi_noIP, Toast.LENGTH_SHORT).show();
                return;
            }
            pro_bar.setVisibility(View.VISIBLE);
            new Thread() {
                @Override
                public void run() {
                    super.run();
                    try {
                        Printer printer = PrinterHelper.connectWifi(strIP);
                        runOnUiThread(() -> {
                            pro_bar.setVisibility(View.GONE);
                            if (printer == null){
                                txtTips.setText(thisCon.getString(R.string.activity_main_connecterr));
                            }else{
                                publicFunction.writeSharedPreferencesData("IP",strIP);
                                PrinterUtils.addPrinter(printer);
                                Intent intent = new Intent();
                                intent.putExtra("is_connected", "OK");
                                intent.putExtra("PRINT_TAG", printer.getPrinterTAG());
                                setResult(Constant.ACTIVITY_CONNECT_WIFI, intent);
                                finish();
                            }
                        });
                    } catch (Exception e) {
                        runOnUiThread(() -> {
                            pro_bar.setVisibility(View.GONE);
                            txtTips.setText(thisCon.getString(R.string.activity_main_connecterr));
                        });
                    }
                }
            }.start();

        } catch (Exception e) {
            Log.d("SDKSample", (new StringBuilder("Activity_Wifi --> onClickConnect ")).append(e.getMessage()).toString());
            runOnUiThread(() -> {
                pro_bar.setVisibility(View.GONE);
                txtTips.setText(thisCon.getString(R.string.activity_main_connecterr));
            });
        }
    }

    public void onClickCancel(View view) {
        if (!CheckClick.isClickEvent()) return;
        try {
            this.finish();
        } catch (Exception e) {
            Log.d("SDKSample", (new StringBuilder("Activity_Wifi --> onClickCancel ")).append(e.getMessage()).toString());
        }
    }
}
