package com.sdk.esc;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.luck.picture.lib.utils.ToastUtils;
import com.prt.esc.PrinterHelper;
import com.prt.esc.printer.Printer;
import com.prt.esc.utils.UDPConnectionUtil;

import java.util.ArrayList;


public class Activity_UDP extends Activity {

    private RecyclerView recyclerView;
    private BaseQuickAdapter<String, BaseViewHolder> baseQuickAdapter;
    private ArrayList<String> strings;
    private Context mContext;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_udp);
        mContext = getApplicationContext();
        recyclerView = (RecyclerView) findViewById(R.id.recy_udp);
        strings = new ArrayList<String>();
        baseQuickAdapter = new BaseQuickAdapter<String, BaseViewHolder>(android.R.layout.simple_list_item_1, strings) {
            @Override
            protected void convert(BaseViewHolder helper, String item) {
                helper.setText(android.R.id.text1, item);
            }
        };
        recyclerView.setLayoutManager(new LinearLayoutManager(mContext));
        recyclerView.setAdapter(baseQuickAdapter);
        baseQuickAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, final int position) {
                new Thread() {
                    @Override
                    public void run() {
                        super.run();
                        try {
                            Log.d("TAG", "IP:" + strings.get(position));
                            String ip = strings.get(position).split("\\n")[0];
                            Printer printer = PrinterHelper.connectWifi(ip);
                            if (printer != null) {
                                PrinterUtils.addPrinter(printer);
                                Intent intent = new Intent();
                                intent.putExtra("is_connected", "OK");
                                intent.putExtra("PRINT_TAG", printer.getPrinterTAG());
                                setResult(Constant.ACTIVITY_CONNECT_WIFI, intent);
                                finish();
                            } else {
                                ToastUtils.showToast(mContext, getString(R.string.activity_main_connecterr));
                            }
                        } catch (Exception e) {
                            ToastUtils.showToast(mContext, getString(R.string.activity_main_connecterr));
                        }
                    }
                }.start();
            }
        });
        UDPConnectionUtil.getUdpIP(mContext, (ip, sn, mac) -> runOnUiThread(() -> {
            strings.add(ip + "\n" + sn + "\n" + mac);
            baseQuickAdapter.notifyDataSetChanged();
        }));
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        UDPConnectionUtil.closeScan();
    }
}
