package com.sdk.esc;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.Spinner;
import android.widget.Toast;

import com.luck.picture.lib.utils.ToastUtils;
import com.prt.esc.printer.Printer;

import java.util.Iterator;


public class Activity_TextFormat extends Activity {
    private Context thisCon = null;
    private EditText txtText = null;
    private EditText txtLeftMargin = null;
    private CheckBox chkUnderline = null;
    private CheckBox chkBold = null;
    private CheckBox chkTurnWhite = null;
    private RadioButton rdoLeft = null;
    private RadioButton rdoCenter = null;
    private Spinner spnHeightMultiple = null;
    private ArrayAdapter arrHeightMultiple;
    private Spinner spnWidthMultiple = null;
    private ArrayAdapter arrWidthMultiple;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
        setContentView(R.layout.activity_text_format);
        thisCon = this.getApplicationContext();

        txtText = (EditText) findViewById(R.id.txtText);
        txtLeftMargin = (EditText) findViewById(R.id.txtLeftMargin);
        chkUnderline = (CheckBox) findViewById(R.id.chkUnderline);
        chkBold = (CheckBox) findViewById(R.id.chkBold);
        chkTurnWhite = (CheckBox) findViewById(R.id.chkTurnWhite);
        rdoLeft = (RadioButton) this.findViewById(R.id.rdoLeft);
        rdoCenter = (RadioButton) this.findViewById(R.id.rdoCenter);

        spnHeightMultiple = (Spinner) findViewById(R.id.spnHeighMultiple);
        arrHeightMultiple = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item);
        arrHeightMultiple = ArrayAdapter.createFromResource(this, R.array.activity_text_format_multiple, android.R.layout.simple_spinner_item);
        arrHeightMultiple.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnHeightMultiple.setAdapter(arrHeightMultiple);

        spnWidthMultiple = (Spinner) findViewById(R.id.spnWidthMultiple);
        arrWidthMultiple = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item);
        arrWidthMultiple = ArrayAdapter.createFromResource(this, R.array.activity_text_format_multiple, android.R.layout.simple_spinner_item);
        arrWidthMultiple.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnWidthMultiple.setAdapter(arrWidthMultiple);
    }

    public void onClickPrint(View view) {
        if (!CheckClick.isClickEvent()) return;
        int iLeftMargin = 0;
        try {
            String sText = txtText.getText().toString().trim();
            if (sText.length() == 0) {
                Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_no_data), Toast.LENGTH_SHORT).show();
                return;
            }

            if (txtLeftMargin.getText().toString().trim().length() == 0) {
                Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_no_data), Toast.LENGTH_SHORT).show();
                return;
            } else {
                iLeftMargin = Integer.valueOf(txtLeftMargin.getText().toString().trim());
            }

            int iAlignment = 0;

            iAlignment = (rdoLeft.isChecked() ? 0 : (rdoCenter.isChecked() ? 1 : 2));

            for (Iterator<Printer> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                Printer printer = iterator.next();
                printer.addLeftMargin(iLeftMargin);
                printer.addText(sText,iAlignment, false, chkBold.isChecked(), chkUnderline.isChecked(), chkTurnWhite.isChecked(), spnWidthMultiple.getSelectedItemPosition(), spnHeightMultiple.getSelectedItemPosition());
                boolean result = printer.print();
                if (!result) {
                    printerSendFail(iterator, printer);
                }
            }
        } catch (Exception e) {
            Log.d("SDKSample", (new StringBuilder("Activity_TextFormat --> onClickPrint ")).append(e.getMessage()).toString());
        }
    }
    private void printerSendFail(Iterator<Printer> iterator, Printer printer) {
        ToastUtils.showToast(thisCon, printer.getPrinterTAG() + " send fail");
        iterator.remove();
    }
}
