package com.sdk.esc;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Spinner;

import com.prt.esc.printer.Printer;

import java.util.Iterator;

import com.prt.esc.printer.PublicFunction;

public class Activity_Setting extends Activity {
    private Spinner spnCodepage = null;

    private ArrayAdapter arrCodepage;

    private PublicFunction publicFunction = null;
    private Context thisCon = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
        setContentView(R.layout.activity_setting);

        spnCodepage = (Spinner) findViewById(R.id.spnCodepage);
        arrCodepage = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item);
        arrCodepage = ArrayAdapter.createFromResource(this, R.array.codepage, android.R.layout.simple_spinner_item);
        arrCodepage.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnCodepage.setAdapter(arrCodepage);
        spnCodepage.setOnItemSelectedListener(new OnItemSelectedCodepage());
        thisCon = this.getApplicationContext();
        publicFunction = new PublicFunction(thisCon);
        InitSetting();
    }

    private void InitSetting() {
        String SettingValue = "";
        SettingValue = publicFunction.readSharedPreferencesData("Codepage");
        if (SettingValue.equals("")) {
            publicFunction.writeSharedPreferencesData("Codepage", "0,PC437(USA:Standard Europe)");
            SettingValue = "0";
        }
        spnCodepage.setSelection(Integer.parseInt(SettingValue.split(",")[0]));
    }

    private class OnItemSelectedCodepage implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            try {
                String sCodepage = arrCodepage.getItem(arg2).toString();
                publicFunction.writeSharedPreferencesData("Codepage", String.valueOf(arg2) + "," + sCodepage);
                String sLEncode = publicFunction.getLanguageEncode(sCodepage);
                int intLanguageNum = publicFunction.getCodePageIndex(sCodepage);
                for (Iterator<Printer> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                    Printer printer = iterator.next();
                    printer.setLanguageEncode(sLEncode);
                }
            } catch (Exception e) {

            }
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
            // TODO Auto-generated method stub
        }
    }

}
