package com.sdk.esc;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;

import com.luck.picture.lib.utils.ToastUtils;
import com.prt.esc.printer.Printer;

import java.util.Iterator;



public class Activity_Cashdrawer extends Activity {
    private Context thisCon;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
        setContentView(R.layout.activity_cashdrawer);
        thisCon = this;
    }

    public void onClickOpen1(View view) {
        if (!CheckClick.isClickEvent()) return;

        try {
            for (Iterator<Printer> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                Printer printer = iterator.next();
                printer.addOpenCashDrawer(0);
                boolean result = printer.print();
                if (!result) {
                    printerSendFail(iterator, printer);
                }
            }
        } catch (Exception e) {
            Log.d("SDKSample", (new StringBuilder("Activity_Cashdrawer --> onClickOpen1 ")).append(e.getMessage()).toString());
        }
    }

    public void onClickOpen2(View view) {
        if (!CheckClick.isClickEvent()) return;

        try {
            for (Iterator<Printer> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                Printer printer = iterator.next();
                printer.addOpenCashDrawer(1);
                boolean result = printer.print();
                if (!result) {
                    printerSendFail(iterator, printer);
                }
            }
        } catch (Exception e) {
            Log.d("SDKSample", (new StringBuilder("Activity_Cashdrawer --> onClickOpen2 ")).append(e.getMessage()).toString());
        }
    }

    public void onClickOpen12(View view) {
        if (!CheckClick.isClickEvent()) return;

        try {
            for (Iterator<Printer> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                Printer printer = iterator.next();
                printer.addOpenCashDrawer(2);
                boolean result = printer.print();
                if (!result) {
                    printerSendFail(iterator, printer);
                }
            }
        } catch (Exception e) {
            Log.d("SDKSample", (new StringBuilder("Activity_Cashdrawer --> onClickOpen12 ")).append(e.getMessage()).toString());
        }
    }
    private void printerSendFail(Iterator<Printer> iterator, Printer printer) {
        ToastUtils.showToast(thisCon, printer.getPrinterTAG() + " send fail");
        iterator.remove();
    }
}
