package com.sdk.esc;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.Toast;

import com.luck.picture.lib.utils.ToastUtils;
import com.prt.esc.printer.Printer;

import java.util.Iterator;

import com.prt.esc.utils.BarCodeUtil;


public class Activity_1DBarcodes extends Activity {
    private Context thisCon = null;
    private Spinner spnBarcodeType = null;
    private ArrayAdapter arrBarcodeType;
    private Spinner spnBarcodeWidth = null;
    private ArrayAdapter arrBarcodeWidth;
    private Spinner spnBarcodeHRILayout = null;
    private ArrayAdapter arrBarcodeHRILayout;
    private EditText txtBarcodeData = null;
    private EditText txtBarcodeHeight = null;
    private RadioButton rdoLeft = null;
    private RadioButton rdoCenter = null;
    private RadioButton rdoRight = null;
    private RadioGroup rdoGroup = null;

    private int justification = 0;
    private int barcodeType = 0;
    private int barcodeWidth = 2;
    private int barcodeHRILayout = 0;

    @SuppressWarnings("unchecked")
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
        setContentView(R.layout.activity_1dbarcodes);
        thisCon = this.getApplicationContext();

        spnBarcodeType = (Spinner) findViewById(R.id.spnBarcodeType);
        arrBarcodeType = ArrayAdapter.createFromResource(this, R.array.activity_1dbarcodes_barcode_type, android.R.layout.simple_spinner_item);
        arrBarcodeType.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnBarcodeType.setAdapter(arrBarcodeType);
        spnBarcodeType.setOnItemSelectedListener(new OnItemSelectedBarcodeType());

        spnBarcodeWidth = (Spinner) findViewById(R.id.spnBarcodeWidth);
        arrBarcodeWidth = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item);
        arrBarcodeWidth = ArrayAdapter.createFromResource(this, R.array.activity_1dbarcodes_width, android.R.layout.simple_spinner_item);
        arrBarcodeWidth.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnBarcodeWidth.setAdapter(arrBarcodeWidth);
        spnBarcodeWidth.setOnItemSelectedListener(new OnItemSelectedBarcodeWidth());

        spnBarcodeHRILayout = (Spinner) findViewById(R.id.spnBarcodeHRILayout);
        arrBarcodeHRILayout = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item);
        arrBarcodeHRILayout = ArrayAdapter.createFromResource(this, R.array.activity_1dbarcodes_hri_position, android.R.layout.simple_spinner_item);
        arrBarcodeHRILayout.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnBarcodeHRILayout.setAdapter(arrBarcodeHRILayout);
        spnBarcodeHRILayout.setOnItemSelectedListener(new OnItemSelectedBarcodeHRILayout());

        txtBarcodeData = (EditText) this.findViewById(R.id.txtBarcodeData);
        txtBarcodeHeight = (EditText) this.findViewById(R.id.txtBarcodeHeight);
        rdoLeft = (RadioButton) this.findViewById(R.id.rdoLeft);
        rdoCenter = (RadioButton) this.findViewById(R.id.rdoCenter);
        rdoRight = (RadioButton) this.findViewById(R.id.rdoRight);
        rdoGroup = (RadioGroup) this.findViewById(R.id.radioGroup1);
        rdoGroup.setOnCheckedChangeListener((group, checkedId) -> {
            if (checkedId == rdoLeft.getId()) {
                justification = 0;
            } else if (checkedId == rdoCenter.getId()) {
                justification = 1;
            } else if (checkedId == rdoRight.getId()) {
                justification = 2;
            }
        });
    }

    private class OnItemSelectedBarcodeType implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            barcodeType = arg2;
            switch (barcodeType) {
                case 0:
                    txtBarcodeData.setText(thisCon.getString(R.string.activity_1dbarcodes_UPC_A));
                    break;
                case 1:
                    txtBarcodeData.setText(thisCon.getString(R.string.activity_1dbarcodes_UPC_E));
                    break;
                case 2:
                    txtBarcodeData.setText(thisCon.getString(R.string.activity_1dbarcodes_JAN13));
                    break;
                case 3:
                    txtBarcodeData.setText(thisCon.getString(R.string.activity_1dbarcodes_JAN8));
                    break;
                case 4:
                    txtBarcodeData.setText(thisCon.getString(R.string.activity_1dbarcodes_CODE39));
                    break;
                case 5:
                    txtBarcodeData.setText(thisCon.getString(R.string.activity_1dbarcodes_ITF));
                    break;
                case 6:
                    txtBarcodeData.setText(thisCon.getString(R.string.activity_1dbarcodes_CODABAR));
                    break;
                case 7:
                    txtBarcodeData.setText(thisCon.getString(R.string.activity_1dbarcodes_CODE93));
                    break;
                case 8:
                    txtBarcodeData.setText(thisCon.getString(R.string.activity_1dbarcodes_CODE128));
                    break;
            }
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
        }
    }

    private class OnItemSelectedBarcodeWidth implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            barcodeWidth = Integer.valueOf(arrBarcodeWidth.getItem(arg2).toString());
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
            // TODO Auto-generated method stub
        }
    }

    private class OnItemSelectedBarcodeHRILayout implements OnItemSelectedListener {
        @Override
        public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
            barcodeHRILayout = arg2;
        }

        @Override
        public void onNothingSelected(AdapterView<?> arg0) {
            // TODO Auto-generated method stub
        }
    }

    public void onClickPrint(View view) {
        if (!CheckClick.isClickEvent()) return;

        try {
            String bcData = txtBarcodeData.getText().toString();
            if (bcData.trim().length() == 0) {
                Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_no_data), Toast.LENGTH_SHORT).show();
                return;
            }
            if (barcodeType == 0) {
                if (bcData.trim().length() == 11 || bcData.trim().length() == 12) {

                } else {
                    Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_data_error), Toast.LENGTH_SHORT).show();
                    return;
                }
            }
            if (barcodeType == 1) {
                if (bcData.trim().length() == 11 || bcData.trim().length() == 12) {

                } else {
                    Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_data_error), Toast.LENGTH_SHORT).show();
                    return;
                }
            }
            if (barcodeType == 3) {
                if (bcData.trim().length() == 7 || bcData.trim().length() == 8) {

                } else {
                    Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_data_error), Toast.LENGTH_SHORT).show();
                    return;
                }
            }
            if (barcodeType == 2) {
                if (bcData.trim().length() == 12 || bcData.trim().length() == 13) {

                } else {
                    Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_data_error), Toast.LENGTH_SHORT).show();
                    return;
                }
            }
            if (barcodeType == 4) {
                if (255 >= bcData.trim().length() && bcData.trim().length() >= 1) {

                } else {
                    Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_data_error), Toast.LENGTH_SHORT).show();
                    return;
                }
            }
            if (barcodeType == 5) {
                if (254 >= bcData.trim().length() && bcData.trim().length() >= 2) {

                } else {
                    Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_data_error), Toast.LENGTH_SHORT).show();
                    return;
                }
            }
            if (barcodeType == 6) {
                if (255 >= bcData.trim().length() && bcData.trim().length() >= 2) {

                } else {
                    Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_data_error), Toast.LENGTH_SHORT).show();
                    return;
                }
            }
            if (barcodeType == 7) {
                if (255 >= bcData.trim().length() && bcData.trim().length() >= 1) {

                } else {
                    Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_data_error), Toast.LENGTH_SHORT).show();
                    return;
                }
            }
            if (barcodeType == 8) {
                if (255 >= bcData.trim().length() && bcData.trim().length() >= 2) {
                    bcData = BarCodeUtil.getBarCode128Data(bcData);
                } else {
                    Toast.makeText(thisCon, getString(R.string.activity_1dbarcodes_data_error), Toast.LENGTH_SHORT).show();
                    return;
                }
            }
            for (Iterator<Printer> iterator = PrinterUtils.getPrinters().iterator(); iterator.hasNext(); ) {
                Printer printer = iterator.next();
                printer.addBarCode(barcodeType + 65, bcData, barcodeWidth, Integer.valueOf(this.txtBarcodeHeight.getText().toString()), barcodeHRILayout, justification);
                boolean result = printer.print();
                if (!result) {
                    printerSendFail(iterator, printer);
                }
            }
        } catch (Exception e) {
            Log.d("SDKSample", (new StringBuilder("Activity_1DBarcodes --> onClickPrint ")).append(e.getMessage()).toString());
        }
    }
    private void printerSendFail(Iterator<Printer> iterator, Printer printer) {
        ToastUtils.showToast(thisCon, printer.getPrinterTAG() + " send fail");
        iterator.remove();
    }
}